/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import java.util.List;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.Point;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilder;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.codec.db.oracle.AbstractSDODecoder;
import org.geolatte.geom.codec.db.oracle.Element;
import org.geolatte.geom.codec.db.oracle.SDOGType;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.SdoGeometryType;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class PointSdoDecoder
extends AbstractSDODecoder {
    @Override
    public boolean accepts(SDOGeometry nativeGeom) {
        return nativeGeom.getGType().getTypeGeometry() == SdoGeometryType.POINT;
    }

    @Override
    protected Geometry<?> internalDecode() {
        CoordinateReferenceSystem<?> crs = this.nativeGeom.getCoordinateReferenceSystem();
        if (this.nativeGeom.getPoint() != null) {
            Double[] ordinates = this.nativeGeom.getDimension() == 2 ? new Double[]{this.nativeGeom.getPoint().x, this.nativeGeom.getPoint().y} : new Double[]{this.nativeGeom.getPoint().x, this.nativeGeom.getPoint().y, this.nativeGeom.getPoint().z};
            return new Point(this.buildSeq(ordinates, crs.getPositionClass()), (CoordinateReferenceSystem<PositionSequence<?>>)crs);
        }
        return this.decode(this.nativeGeom.getGType(), this.nativeGeom.getElements(), crs);
    }

    @Override
    protected <P extends Position> Geometry<P> decode(SDOGType gtype, List<Element> elements, CoordinateReferenceSystem<P> crs) {
        assert (elements.size() <= 1);
        return new Point<PositionSequence<P>>(elements.get(0).linearizedPositions(gtype, crs), crs);
    }

    private <P extends Position> PositionSequence<P> buildSeq(Double[] ordinates, Class<P> posClass) {
        PositionSequenceBuilder<double[]> builder = PositionSequenceBuilders.fixedSized(1, posClass);
        double[] coords = new double[ordinates.length];
        for (int i = 0; i < ordinates.length; ++i) {
            coords[i] = ordinates[i] == null ? Double.NaN : ordinates[i];
        }
        builder.add(coords);
        return builder.toPositionSequence();
    }
}

