/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.db.oracle.ElementType;
import org.geolatte.geom.codec.db.oracle.SdoGeometryType;

class SDOGType {
    private int dimension = 2;
    private int lrsDimension;
    private SdoGeometryType sdoGeometryType = SdoGeometryType.UNKNOWN_GEOMETRY;

    static <P extends Position> SDOGType gtypeFor(Geometry<P> geometry) {
        SdoGeometryType sdoGeometryType = SdoGeometryType.forGeometry(geometry);
        if (sdoGeometryType == null) {
            throw new IllegalStateException("Can't determine TypeGeometry for geometries of type " + geometry.getGeometryType());
        }
        int lrsDimension = geometry.hasM() ? geometry.getCoordinateDimension() : 0;
        return new SDOGType(geometry.getCoordinateDimension(), lrsDimension, sdoGeometryType);
    }

    @Deprecated
    static SDOGType derive(ElementType elementType, SDOGType gtype) {
        switch (elementType) {
            case POINT: 
            case ORIENTATION: {
                return new SDOGType(gtype.getDimension(), gtype.getLRSDimension(), SdoGeometryType.POINT);
            }
            case POINT_CLUSTER: {
                return new SDOGType(gtype.getDimension(), gtype.getLRSDimension(), SdoGeometryType.MULTIPOINT);
            }
            case LINE_ARC_SEGMENTS: 
            case LINE_STRAIGTH_SEGMENTS: 
            case COMPOUND_LINESTRING: {
                return new SDOGType(gtype.getDimension(), gtype.getLRSDimension(), SdoGeometryType.LINE);
            }
            case COMPOUND_EXTERIOR_RING: 
            case EXTERIOR_RING_ARC_SEGMENTS: 
            case EXTERIOR_RING_CIRCLE: 
            case EXTERIOR_RING_RECT: 
            case EXTERIOR_RING_STRAIGHT_SEGMENTS: {
                return new SDOGType(gtype.getDimension(), gtype.getLRSDimension(), SdoGeometryType.POLYGON);
            }
        }
        return null;
    }

    public SDOGType(int dimension, int lrsDimension, SdoGeometryType sdoGeometryType) {
        this.setDimension(dimension);
        this.setLrsDimension(lrsDimension);
        this.setTypeGeometry(sdoGeometryType);
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        if (dimension < 2 || dimension > 4) {
            throw new IllegalArgumentException("Dimension can only be 2,3 or 4.");
        }
        this.dimension = dimension;
    }

    public SdoGeometryType getTypeGeometry() {
        return this.sdoGeometryType;
    }

    public void setTypeGeometry(SdoGeometryType sdoGeometryType) {
        this.sdoGeometryType = sdoGeometryType;
    }

    public int getLRSDimension() {
        if (this.lrsDimension > 0) {
            return this.lrsDimension;
        }
        if (this.lrsDimension == 0 && this.dimension == 4) {
            return 4;
        }
        return 0;
    }

    public int getZDimension() {
        if (this.getLRSDimension() == 3 && this.dimension == 3) {
            return -1;
        }
        if (this.getLRSDimension() == 3 && this.dimension == 4) {
            return 4;
        }
        if (this.getLRSDimension() == 4 && this.dimension == 4) {
            return 3;
        }
        return this.dimension > 2 ? 3 : -1;
    }

    public boolean isLRSGeometry() {
        return this.getLRSDimension() > 0;
    }

    public void setLrsDimension(int lrsDimension) {
        if (lrsDimension != 0 && lrsDimension > this.dimension) {
            throw new IllegalArgumentException("lrsDimension must be 0 or lower or equal to dimension.");
        }
        this.lrsDimension = lrsDimension;
    }

    public int intValue() {
        int v = this.dimension * 1000;
        v += this.lrsDimension * 100;
        return v += this.sdoGeometryType.intValue();
    }

    public static SDOGType parse(int v) {
        int dim = v / 1000;
        int lrsDim = (v -= dim * 1000) / 100;
        SdoGeometryType sdoGeometryType = SdoGeometryType.parse(v -= lrsDim * 100);
        return new SDOGType(dim, lrsDim, sdoGeometryType);
    }

    public static SDOGType parse(Object datum) {
        try {
            int v = ((Number)datum).intValue();
            return SDOGType.parse(v);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return Integer.toString(this.intValue());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SDOGType sdogType = (SDOGType)o;
        if (this.dimension != sdogType.dimension) {
            return false;
        }
        if (this.lrsDimension != sdogType.lrsDimension) {
            return false;
        }
        return this.sdoGeometryType == sdogType.sdoGeometryType;
    }

    public int hashCode() {
        int result = this.dimension;
        result = 31 * result + this.lrsDimension;
        result = 31 * result + (this.sdoGeometryType != null ? this.sdoGeometryType.hashCode() : 0);
        return result;
    }
}

