/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.sqlserver;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.db.Decoder;
import org.geolatte.geom.codec.db.sqlserver.OpenGisType;
import org.geolatte.geom.codec.db.sqlserver.SqlServerGeometry;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

abstract class AbstractSqlServerDecoder
implements Decoder<SqlServerGeometry> {
    AbstractSqlServerDecoder() {
    }

    @Override
    public Geometry<?> decode(SqlServerGeometry nativeGeom) {
        if (!this.accepts(nativeGeom)) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " received object of type " + nativeGeom.openGisType());
        }
        if (nativeGeom.isEmpty()) {
            Geometry<?> nullGeom = this.createNullGeometry(nativeGeom.getCoordinateReferenceSystem());
            return nullGeom;
        }
        return this.createGeometry(nativeGeom);
    }

    @Override
    public boolean accepts(OpenGisType type) {
        return type == this.getOpenGisType();
    }

    @Override
    public boolean accepts(SqlServerGeometry nativeGeom) {
        return this.accepts(nativeGeom.openGisType());
    }

    protected abstract OpenGisType getOpenGisType();

    protected abstract Geometry<?> createNullGeometry(CoordinateReferenceSystem<?> var1);

    protected abstract Geometry<?> createGeometry(SqlServerGeometry var1);

    protected abstract Geometry<?> createGeometry(SqlServerGeometry var1, int var2);
}

