/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.support;

import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.Geometries;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilder;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.codec.support.DecodeException;
import org.geolatte.geom.codec.support.Holder;
import org.geolatte.geom.codec.support.PointHolder;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class LinearPositionsHolder
extends Holder {
    private final List<PointHolder> pointHolderList = new ArrayList<PointHolder>();

    public void push(PointHolder holder) {
        this.pointHolderList.add(holder);
    }

    @Override
    public boolean isEmpty() {
        return this.pointHolderList.isEmpty();
    }

    @Override
    public int getCoordinateDimension() {
        return this.pointHolderList.stream().mapToInt(Holder::getCoordinateDimension).max().orElse(0);
    }

    @Override
    public <P extends Position> Geometry<P> toGeometry(CoordinateReferenceSystem<P> crs, GeometryType geomType) {
        if (geomType == GeometryType.LINESTRING) {
            return this.isEmpty() ? Geometries.mkEmptyLineString(crs) : Geometries.mkLineString(this.toPositionSequence(crs), crs);
        }
        if (geomType == GeometryType.MULTIPOINT) {
            return this.isEmpty() ? Geometries.mkEmptyMultiPoint(crs) : Geometries.mkMultiPoint(this.toPositionSequence(crs), crs);
        }
        throw new DecodeException("Can't convert this coordinates array to requested Geomtype: " + geomType);
    }

    public <P extends Position> PositionSequence<P> toPositionSequence(CoordinateReferenceSystem<P> crs) {
        PositionSequenceBuilder builder = PositionSequenceBuilders.fixedSized(this.pointHolderList.size(), crs.getPositionClass());
        this.pointHolderList.forEach(h -> builder.add(h.toPosition(crs)));
        return builder.toPositionSequence();
    }
}

