/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.geolatte.geom.C2D;
import org.geolatte.geom.G2D;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.CrsWktDecoder;
import org.geolatte.geom.codec.WktDecodeException;
import org.geolatte.geom.crs.AngularUnit;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.crs.Geographic2DCoordinateReferenceSystem;
import org.geolatte.geom.crs.LinearUnit;
import org.geolatte.geom.crs.ProjectedCoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrsRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrsRegistry.class);
    private static final ConcurrentHashMap<CrsId, CoordinateReferenceSystem<? extends Position>> crsMap = new ConcurrentHashMap(4000);
    private static final String DELIM = "\\|";

    private static void loadCRS() throws IOException {
        try (BufferedReader reader = CrsRegistry.createReader();){
            String line = reader.readLine();
            CrsWktDecoder decoder = new CrsWktDecoder();
            while (line != null) {
                CrsRegistry.addDefinition(line, decoder);
                line = reader.readLine();
            }
        }
    }

    private static BufferedReader createReader() {
        InputStream in = CrsRegistry.class.getClassLoader().getResourceAsStream("spatial_ref_sys.txt");
        if (in == null) {
            throw new IllegalStateException("Can't find spatial_ref_sys definitions.");
        }
        return new BufferedReader(new InputStreamReader(in));
    }

    private static void addDefinition(String line, CrsWktDecoder decoder) {
        String[] tokens = line.split(DELIM);
        if (!"EPSG".equals(tokens[0])) {
            LOGGER.debug(String.format("Non-EPSG CRS ignored: %s", tokens[2]));
            return;
        }
        int srid = Integer.parseInt(tokens[1]);
        try {
            CoordinateReferenceSystem<? extends Position> crs = decoder.decode(tokens[2], srid);
            crsMap.put(CrsId.valueOf(srid), crs);
        }
        catch (WktDecodeException e) {
            LOGGER.warn(String.format("Can't parse srid %d (%s). \n%s", srid, tokens[2], e.getMessage()));
        }
        catch (RuntimeException e) {
            LOGGER.warn(String.format("Can't parse srid %d (%s) -- inconsistent coordinate system. \n%s", srid, tokens[2], e.getMessage()));
        }
    }

    public static CoordinateReferenceSystem<?> getCoordinateReferenceSystemForEPSG(int epsgCode, CoordinateReferenceSystem<?> fallback) {
        return CrsRegistry.getCoordinateReferenceSystem(CrsId.valueOf(epsgCode), fallback);
    }

    public static CoordinateReferenceSystem<?> getCoordinateReferenceSystem(CrsId crsId, CoordinateReferenceSystem<?> fallback) {
        CoordinateReferenceSystem<? extends Position> crs = crsMap.get(crsId);
        return crs != null ? crs : fallback;
    }

    public static CoordinateReferenceSystem<?> ifAbsentReturnProjected2D(int epsgCode) {
        return CrsRegistry.computeIfAbsent(CrsId.valueOf(epsgCode), key -> CoordinateReferenceSystems.mkProjected(key, LinearUnit.METER));
    }

    public static CoordinateReferenceSystem<?> ifAbsentReturnGeographic2D(int epsgCode) {
        return CrsRegistry.computeIfAbsent(CrsId.valueOf(epsgCode), key -> CoordinateReferenceSystems.mkGeographic(key, AngularUnit.RADIAN));
    }

    public static CoordinateReferenceSystem<?> computeIfAbsent(CrsId crsId, Function<? super CrsId, ? extends CoordinateReferenceSystem<? extends Position>> buildCrs) {
        return crsMap.computeIfAbsent(crsId, buildCrs);
    }

    public static void registerCoordinateReferenceSystem(CoordinateReferenceSystem<?> crs) {
        crsMap.put(crs.getCrsId(), crs);
    }

    public static void registerCoordinateReferenceSystem(CrsId id, CoordinateReferenceSystem<?> crs) {
        crsMap.put(id, crs);
    }

    public static boolean hasCoordinateReferenceSystemForEPSG(int epsgCode) {
        return crsMap.containsKey(CrsId.valueOf(epsgCode));
    }

    public static Geographic2DCoordinateReferenceSystem getGeographicCoordinateReferenceSystemForEPSG(int epsgCode) {
        CoordinateReferenceSystem<? extends Position> crs = crsMap.get(CrsId.valueOf(epsgCode));
        if (crs == null) {
            return null;
        }
        if (crs.getPositionClass().equals(G2D.class)) {
            return (Geographic2DCoordinateReferenceSystem)crs;
        }
        throw new RuntimeException(String.format("EPSG code %d doesn't refer to geographic projection system", epsgCode));
    }

    public static ProjectedCoordinateReferenceSystem getProjectedCoordinateReferenceSystemForEPSG(int epsgCode) {
        CoordinateReferenceSystem<? extends Position> crs = crsMap.get(CrsId.valueOf(epsgCode));
        if (crs == null) {
            return null;
        }
        if (crs.getPositionClass().equals(C2D.class)) {
            return (ProjectedCoordinateReferenceSystem)crs;
        }
        throw new RuntimeException(String.format("EPSG code %d doesn't refer to geographic projection system", epsgCode));
    }

    public static CrsId getCrsIdForEPSG(int epsgCode) {
        CrsId crsId = CrsId.valueOf(epsgCode);
        return crsMap.containsKey(crsId) ? crsId : null;
    }

    static {
        try {
            CrsRegistry.loadCRS();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't read spatial ref system definitions.");
        }
    }
}

