/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import org.geolatte.geom.crs.AngularUnit;
import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.crs.CrsIdentifiable;
import org.geolatte.geom.crs.LinearUnit;

public abstract class Unit
extends CrsIdentifiable {
    public static final AngularUnit DEGREE = new AngularUnit(new CrsId("EPSG", 9122), "degree", 0.01745329251994328);
    public static final AngularUnit RADIAN = new AngularUnit(new CrsId("EPSG", 9101), "radian", 1.0);
    public static final LinearUnit METER = new LinearUnit(new CrsId("EPSG", 9001), "metre", 1.0);
    public static final LinearUnit UNKNOWN_LINEAR = new LinearUnit(CrsId.UNDEFINED, "unknown", 1.0);
    public static final AngularUnit UNKNOWN_Angular = new AngularUnit(CrsId.UNDEFINED, "unknown", 1.0);
    private final double conversionFactor;

    public Unit(CrsId crsId, String name, double conversionFactor) {
        super(crsId, name);
        this.conversionFactor = conversionFactor;
    }

    public abstract Unit getFundamentalUnit();

    public double getConversionFactor() {
        return this.conversionFactor;
    }

    public abstract boolean isAngular();

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Unit unit = (Unit)o;
        return Double.compare(unit.conversionFactor, this.conversionFactor) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.conversionFactor);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Unit{SRID=" + this.getCrsId().toString() + ", conversionFactor=" + this.conversionFactor + "}";
    }
}

