/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.generator;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.geolatte.geom.generator.Choice;
import org.geolatte.geom.generator.Generator;

public class ValueGeneratorFactory {
    private final Random rnd;

    public ValueGeneratorFactory(Random rnd) {
        this.rnd = rnd;
    }

    public ValueGeneratorFactory() {
        this(new Random());
    }

    public Generator<String> stringGenerator(final int minLength, final int maxLength) {
        return new Generator<String>(){
            private final Choice<Character> ascii = new Choice<Character>(ValueGeneratorFactory.asciiRange());

            @Override
            public String generate() {
                int length = minLength + ValueGeneratorFactory.this.rnd.nextInt(maxLength - minLength + 1);
                char[] chars = new char[length];
                IntStream.range(0, length).forEach(i -> {
                    chars[i] = this.ascii.generate().charValue();
                });
                return String.valueOf(chars);
            }
        };
    }

    public Generator<Integer> integerGenerator(int min, int max) {
        return () -> min + this.rnd.nextInt(max - min + 1);
    }

    public Generator<Double> doubleGenerator(double min, double max) {
        return () -> min + this.rnd.nextDouble() * (max - min);
    }

    public Generator<Instant> instantGenerator(Instant start, Instant end) {
        return () -> {
            long seconds = Duration.between(start, end).getSeconds();
            return Instant.ofEpochSecond(start.getEpochSecond() + (long)(this.rnd.nextDouble() * (double)seconds));
        };
    }

    private static List<Character> asciiRange() {
        return IntStream.rangeClosed(97, 122).mapToObj(i -> Character.valueOf((char)i)).collect(Collectors.toList());
    }
}

