/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.jts;

import java.io.Serializable;
import java.util.Arrays;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilder;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

class PointSequenceCoordinateSequenceFactory
implements CoordinateSequenceFactory,
Serializable {
    private static final long serialVersionUID = 6884205871950410216L;

    PointSequenceCoordinateSequenceFactory() {
    }

    public CoordinateSequence create(Coordinate[] coordinates) {
        CoordinateReferenceSystem<?> crs = this.determineCRS(coordinates);
        return this.fromCoordinateArray(coordinates, crs);
    }

    public CoordinateSequence create(CoordinateSequence coordSeq) {
        return coordSeq;
    }

    public CoordinateSequence create(int size, int dimension) {
        return new CoordinateArraySequence(size, dimension);
    }

    public CoordinateSequence create(int size, int dimension, int measures) {
        int spatial = dimension - measures;
        if (measures > 1) {
            measures = 1;
        }
        if (spatial > 3) {
            spatial = 3;
        }
        if (spatial < 2) {
            spatial = 2;
        }
        return new CoordinateArraySequence(size, spatial + measures, measures);
    }

    public <P extends Position> PositionSequence<P> toPositionSequence(CoordinateSequence cs, Class<P> posType, CoordinateReferenceSystem<P> crs) {
        if (cs instanceof PositionSequence && ((PositionSequence)cs).getPositionClass().equals(posType)) {
            return (PositionSequence)cs;
        }
        Coordinate c = new Coordinate();
        double[] psc = new double[crs.getCoordinateDimension()];
        Arrays.fill(psc, Double.NaN);
        PositionSequenceBuilder<double[]> builder = PositionSequenceBuilders.fixedSized(cs.size(), posType);
        for (int i = 0; i < cs.size(); ++i) {
            psc[0] = cs.getX(i);
            psc[1] = cs.getY(i);
            if (CoordinateReferenceSystems.hasVerticalAxis(crs)) {
                psc[2] = cs.getZ(i);
            }
            if (CoordinateReferenceSystems.hasMeasureAxis(crs)) {
                double mOrdinate;
                int idxM = CoordinateReferenceSystems.hasVerticalAxis(crs) ? 3 : 2;
                psc[idxM] = mOrdinate = cs.getM(i);
            }
            builder.add(psc);
        }
        return builder.toPositionSequence();
    }

    private CoordinateReferenceSystem<?> determineCRS(Coordinate[] coordinates) {
        boolean hasZ;
        boolean hasM = false;
        if (coordinates == null || coordinates.length == 0) {
            return CoordinateReferenceSystems.PROJECTED_2D_METER;
        }
        hasM = !Double.isNaN(coordinates[0].getM());
        boolean bl = hasZ = !Double.isNaN(coordinates[0].getZ());
        if (hasM && hasZ) {
            return CoordinateReferenceSystems.PROJECTED_3DM_METER;
        }
        if (hasM) {
            return CoordinateReferenceSystems.PROJECTED_2DM_METER;
        }
        if (hasZ) {
            return CoordinateReferenceSystems.PROJECTED_3D_METER;
        }
        return CoordinateReferenceSystems.PROJECTED_2D_METER;
    }

    private <P extends Position> CoordinateSequence fromCoordinateArray(Coordinate[] coordinates, CoordinateReferenceSystem<P> crs) {
        PositionSequenceBuilder<double[]> builder = PositionSequenceBuilders.fixedSized(coordinates.length, crs.getPositionClass());
        double[] ordinates = new double[crs.getCoordinateDimension()];
        for (Coordinate co : coordinates) {
            this.copy(co, ordinates, crs);
            builder.add(ordinates);
        }
        return (CoordinateSequence)builder.toPositionSequence();
    }

    private <P extends Position> void copy(Coordinate co, double[] ordinates, CoordinateReferenceSystem<P> crs) {
        ordinates[0] = co.getX();
        ordinates[1] = co.getY();
        boolean hasVerticalAxis = CoordinateReferenceSystems.hasVerticalAxis(crs);
        if (hasVerticalAxis) {
            ordinates[2] = co.getZ();
        }
        if (CoordinateReferenceSystems.hasMeasureAxis(crs)) {
            int idxM = hasVerticalAxis ? 3 : 2;
            ordinates[idxM] = co.getM();
        }
    }
}

