/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.util.Arrays;
import java.util.Iterator;
import org.geolatte.geom.Complex;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.GeometryVisitor;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.Polygonal;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class Polygon<P extends Position>
extends Geometry<P>
implements Polygonal<P>,
Complex<P, LinearRing<P>> {
    private final LinearRing<P>[] rings;

    public Polygon(CoordinateReferenceSystem<P> crs) {
        super(crs);
        this.rings = new LinearRing[0];
    }

    public Polygon(PositionSequence<P> positionSequence, CoordinateReferenceSystem<P> crs) {
        this(new LinearRing<P>(positionSequence, crs));
    }

    public Polygon(LinearRing<P> ... rings) {
        super(Polygon.nestPositionSequences(rings), Polygon.getCrs(rings));
        this.checkRings(rings);
        this.rings = Arrays.copyOf(rings, rings.length);
    }

    private void checkRings(LinearRing<P>[] rings) {
        CoordinateReferenceSystem<P> crs = Polygon.getCrs(rings);
        for (LinearRing<P> ring : rings) {
            this.checkLinearRing(ring, crs);
        }
    }

    private void checkLinearRing(LinearRing<P> ring, CoordinateReferenceSystem<P> crs) {
        if (ring == null) {
            throw new IllegalArgumentException("NULL linear ring is not valid.");
        }
        if (ring.isEmpty()) {
            throw new IllegalArgumentException("Empty linear ring is not valid.");
        }
        if (!ring.getCoordinateReferenceSystem().equals(crs)) {
            throw new IllegalArgumentException("Linear ring with different CRS than exterior boundary.");
        }
    }

    public LinearRing<P> getExteriorRing() {
        return this.isEmpty() ? new LinearRing<P>(this.getPositions(), this.getCoordinateReferenceSystem()) : this.rings[0];
    }

    public int getNumInteriorRing() {
        return this.isEmpty() ? 0 : this.rings.length - 1;
    }

    public LinearRing<P> getInteriorRingN(int index) {
        return this.rings[index + 1];
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.POLYGON;
    }

    @Override
    public Iterator<LinearRing<P>> iterator() {
        return new Iterator<LinearRing<P>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < Polygon.this.rings.length;
            }

            @Override
            public LinearRing<P> next() {
                return Polygon.this.rings[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void accept(GeometryVisitor<P> visitor) {
        visitor.visit(this);
    }

    @Override
    public int getNumGeometries() {
        return this.rings.length;
    }

    @Override
    public Class<? extends Geometry> getComponentType() {
        return LinearRing.class;
    }

    public LinearRing<P>[] components() {
        return Arrays.copyOf(this.rings, this.rings.length);
    }
}

