/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geolatte.geom.Geometries;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.LineString;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.MultiPoint;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.codec.AbstractWktDecoder;
import org.geolatte.geom.codec.PostgisWktVariant;
import org.geolatte.geom.codec.WktDecodeException;
import org.geolatte.geom.codec.WktDecoder;
import org.geolatte.geom.codec.WktGeometryToken;
import org.geolatte.geom.codec.WktPointSequenceToken;
import org.geolatte.geom.codec.WktTokenizer;
import org.geolatte.geom.codec.WktVariant;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.crs.CrsRegistry;

class PostgisWktDecoder
extends AbstractWktDecoder<Geometry<?>>
implements WktDecoder {
    private static final PostgisWktVariant WKT_GEOM_TOKENS = new PostgisWktVariant();
    private static final Pattern SRID_RE = Pattern.compile("^SRID=(.*);", 2);
    private String wktString;
    private CoordinateReferenceSystem<?> crs;

    public PostgisWktDecoder() {
        super(WKT_GEOM_TOKENS);
    }

    protected PostgisWktDecoder(WktVariant wktVariant) {
        super(wktVariant);
    }

    @Override
    public Geometry<?> decode(String wkt) {
        return this.decode(wkt, null);
    }

    @Override
    public <P extends Position> Geometry<P> decode(String wkt, CoordinateReferenceSystem<P> crs) {
        if (wkt == null || wkt.isEmpty()) {
            throw new WktDecodeException("Null or empty string cannot be decoded into a geometry");
        }
        this.prepare(wkt, crs);
        this.initializeTokenizer(crs != null);
        return this.decodeGeometry(this.crs);
    }

    private <P extends Position> void prepare(String wkt, CoordinateReferenceSystem<P> crs) {
        Matcher matcher = SRID_RE.matcher(wkt);
        if (matcher.find()) {
            int srid = Integer.parseInt(matcher.group(1));
            this.crs = crs != null ? crs : CrsRegistry.getCoordinateReferenceSystemForEPSG(srid, CoordinateReferenceSystems.PROJECTED_2D_METER);
            this.wktString = wkt.substring(matcher.end());
        } else {
            this.crs = crs != null ? crs : CoordinateReferenceSystems.PROJECTED_2D_METER;
            this.wktString = wkt;
        }
    }

    private void initializeTokenizer(boolean forceToCRS) {
        this.setTokenizer(new WktTokenizer(this.wktString, this.getWktVariant(), this.crs, forceToCRS));
        this.nextToken();
    }

    private <P extends Position> Geometry<P> decodeGeometry(CoordinateReferenceSystem<P> crs) {
        if (!(this.currentToken instanceof WktGeometryToken)) {
            throw new WktDecodeException(this.buildWrongSymbolAtPositionMsg());
        }
        GeometryType type = ((WktGeometryToken)this.currentToken).getType();
        this.nextToken();
        switch (type) {
            case POINT: {
                return this.decodePointText(crs);
            }
            case LINESTRING: {
                return this.decodeLineStringText(crs);
            }
            case POLYGON: {
                return this.decodePolygonText(crs);
            }
            case GEOMETRYCOLLECTION: {
                return this.decodeGeometryCollection(crs);
            }
            case MULTIPOINT: {
                return this.decodeMultiPoint(crs);
            }
            case MULTILINESTRING: {
                return this.decodeMultiLineString(crs);
            }
            case MULTIPOLYGON: {
                return this.decodeMultiPolygon(crs);
            }
        }
        throw new WktDecodeException("Unsupported geometry type in Wkt: " + (Object)((Object)type));
    }

    private <P extends Position> MultiPolygon<P> decodeMultiPolygon(CoordinateReferenceSystem<P> crs) {
        if (this.matchesOpenList()) {
            ArrayList polygons = new ArrayList();
            while (!this.matchesCloseList()) {
                polygons.add(this.decodePolygonText(crs));
                this.matchesElementSeparator();
            }
            return Geometries.mkMultiPolygon(polygons);
        }
        if (this.matchesEmptyToken()) {
            return new MultiPolygon<P>(crs);
        }
        throw new WktDecodeException(this.buildWrongSymbolAtPositionMsg());
    }

    private <P extends Position> Geometry<P> decodeMultiLineString(CoordinateReferenceSystem<P> crs) {
        if (this.matchesOpenList()) {
            ArrayList lineStrings = new ArrayList();
            while (!this.matchesCloseList()) {
                lineStrings.add(this.decodeLineStringText(crs));
                this.matchesElementSeparator();
            }
            return Geometries.mkMultiLineString(lineStrings);
        }
        if (this.matchesEmptyToken()) {
            return new MultiLineString<P>(crs);
        }
        throw new WktDecodeException(this.buildWrongSymbolAtPositionMsg());
    }

    private <P extends Position> Geometry<P> decodeMultiPoint(CoordinateReferenceSystem<P> crs) {
        if (this.matchesOpenList()) {
            ArrayList points = new ArrayList();
            if (this.currentToken instanceof WktPointSequenceToken) {
                PositionSequence positionSequence = ((WktPointSequenceToken)this.currentToken).getPositions();
                CoordinateReferenceSystem tcrs = ((WktPointSequenceToken)this.currentToken).getCoordinateReferenceSystem();
                for (Position p : positionSequence) {
                    points.add(new Point<Position>(p, tcrs));
                }
                this.nextToken();
            }
            while (!this.matchesCloseList()) {
                points.add(this.decodePointText(crs));
                this.matchesElementSeparator();
            }
            return Geometries.mkMultiPoint(points);
        }
        if (this.matchesEmptyToken()) {
            return new MultiPoint<P>(crs);
        }
        throw new WktDecodeException(this.buildWrongSymbolAtPositionMsg());
    }

    private <P extends Position> GeometryCollection<P, Geometry<P>> decodeGeometryCollection(CoordinateReferenceSystem<P> crs) {
        if (this.matchesOpenList()) {
            ArrayList geometries = new ArrayList();
            while (!this.matchesCloseList()) {
                geometries.add(this.decodeGeometry(crs));
                this.matchesElementSeparator();
            }
            return Geometries.mkGeometryCollection(geometries);
        }
        if (this.matchesEmptyToken()) {
            return new GeometryCollection(crs);
        }
        throw new WktDecodeException(this.buildWrongSymbolAtPositionMsg());
    }

    private <P extends Position> Polygon<P> decodePolygonText(CoordinateReferenceSystem<P> crs) {
        if (this.matchesOpenList()) {
            ArrayList rings = new ArrayList();
            while (!this.matchesCloseList()) {
                LinearRing<P> ring = this.decodeLinearRingText(crs);
                if (ring.isEmpty()) {
                    throw new WktDecodeException("Empty ring found in polygonWkt: " + this.wktString);
                }
                rings.add(ring);
                this.matchesElementSeparator();
            }
            return Geometries.mkPolygon(rings);
        }
        if (this.matchesEmptyToken()) {
            return new Polygon<P>(crs);
        }
        throw new WktDecodeException(this.buildWrongSymbolAtPositionMsg());
    }

    private <P extends Position> LinearRing<P> decodeLinearRingText(CoordinateReferenceSystem<P> crs) {
        try {
            WktPointSequenceToken<P> token = this.decodePointSequence(crs);
            if (token == null) {
                throw new WktDecodeException("No Linear Ring when expected");
            }
            return new LinearRing<P>(token.getPositions(), token.getCoordinateReferenceSystem());
        }
        catch (IllegalArgumentException ex) {
            throw new WktDecodeException(ex.getMessage());
        }
    }

    private <P extends Position> LineString<P> decodeLineStringText(CoordinateReferenceSystem<P> crs) {
        WktPointSequenceToken<P> token = this.decodePointSequence(crs);
        if (token != null) {
            PositionSequence<P> positionSequence = token.getPositions();
            CoordinateReferenceSystem<P> tcrs = token.getCoordinateReferenceSystem();
            return new LineString<P>(positionSequence, tcrs);
        }
        if (this.matchesEmptyToken()) {
            return new LineString<P>(crs);
        }
        throw new WktDecodeException(this.buildWrongSymbolAtPositionMsg());
    }

    private <P extends Position> Point<P> decodePointText(CoordinateReferenceSystem<P> crs) {
        WktPointSequenceToken<P> token = this.decodePointSequence(crs);
        if (token != null) {
            PositionSequence<P> positionSequence = token.getPositions();
            CoordinateReferenceSystem<P> tcrs = token.getCoordinateReferenceSystem();
            return new Point<PositionSequence<P>>(positionSequence, tcrs);
        }
        if (this.matchesEmptyToken()) {
            return new Point<P>(crs);
        }
        throw new WktDecodeException(this.buildWrongSymbolAtPositionMsg());
    }

    private boolean matchesEmptyToken() {
        if (this.currentToken == WKT_GEOM_TOKENS.getEmpty()) {
            this.nextToken();
            return true;
        }
        return false;
    }

    private <P extends Position> WktPointSequenceToken<P> decodePointSequence(CoordinateReferenceSystem<P> forceCrs) {
        WktPointSequenceToken token = null;
        if (this.matchesOpenList()) {
            if (!(this.currentToken instanceof WktPointSequenceToken)) {
                throw new WktDecodeException(this.buildWrongSymbolAtPositionMsg());
            }
            token = (WktPointSequenceToken)this.currentToken;
            this.nextToken();
            if (!this.matchesCloseList()) {
                throw new WktDecodeException(this.buildWrongSymbolAtPositionMsg());
            }
        }
        return token;
    }

    private String buildWrongSymbolAtPositionMsg() {
        return "Wrong symbol at position: " + this.getTokenizerPosition() + " in Wkt: " + this.wktString;
    }
}

