/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.C2D;
import org.geolatte.geom.C2DM;
import org.geolatte.geom.C3D;
import org.geolatte.geom.C3DM;
import org.geolatte.geom.Position;
import org.geolatte.geom.crs.AngularUnit;
import org.geolatte.geom.crs.CartesianCoordinateSystem2D;
import org.geolatte.geom.crs.CompoundCoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateSystemAxis;
import org.geolatte.geom.crs.CoordinateSystemAxisDirection;
import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.crs.CrsParameter;
import org.geolatte.geom.crs.CrsRegistry;
import org.geolatte.geom.crs.EllipsoidalCoordinateSystem2D;
import org.geolatte.geom.crs.GeodeticLatitudeCSAxis;
import org.geolatte.geom.crs.GeodeticLongitudeCSAxis;
import org.geolatte.geom.crs.Geographic2DCoordinateReferenceSystem;
import org.geolatte.geom.crs.LinearCoordinateReferenceSystem;
import org.geolatte.geom.crs.LinearUnit;
import org.geolatte.geom.crs.MeasureStraightLineAxis;
import org.geolatte.geom.crs.ProjectedCoordinateReferenceSystem;
import org.geolatte.geom.crs.Projection;
import org.geolatte.geom.crs.SingleCoordinateReferenceSystem;
import org.geolatte.geom.crs.StraightLineAxis;
import org.geolatte.geom.crs.Unit;
import org.geolatte.geom.crs.VerticalCoordinateReferenceSystem;
import org.geolatte.geom.crs.VerticalDatum;
import org.geolatte.geom.crs.VerticalStraightLineAxis;

public class CoordinateReferenceSystems {
    public static final SingleCoordinateReferenceSystem<C2D> PROJECTED_2D_METER = CoordinateReferenceSystems.mkProjected(Unit.METER);
    public static final CompoundCoordinateReferenceSystem<C2DM> PROJECTED_2DM_METER = CoordinateReferenceSystems.addLinearSystem(PROJECTED_2D_METER, C2DM.class, Unit.METER);
    public static final CompoundCoordinateReferenceSystem<C3D> PROJECTED_3D_METER = CoordinateReferenceSystems.addVerticalSystem(PROJECTED_2D_METER, C3D.class, Unit.METER);
    public static final CompoundCoordinateReferenceSystem<C3DM> PROJECTED_3DM_METER = CoordinateReferenceSystems.addLinearSystem(PROJECTED_3D_METER, C3DM.class, Unit.METER);
    public static Geographic2DCoordinateReferenceSystem WGS84 = CrsRegistry.getGeographicCoordinateReferenceSystemForEPSG(4326);

    public static ProjectedCoordinateReferenceSystem mkProjected(int srid, LinearUnit unit) {
        return new ProjectedCoordinateReferenceSystem(CrsId.valueOf(srid), "Generic 2D Projected", CoordinateReferenceSystems.mkGeographic(Unit.DEGREE), Projection.UNKNOWN, new ArrayList<CrsParameter>(), new CartesianCoordinateSystem2D(new StraightLineAxis("X", CoordinateSystemAxisDirection.EAST, unit), new StraightLineAxis("Y", CoordinateSystemAxisDirection.NORTH, unit)));
    }

    public static ProjectedCoordinateReferenceSystem mkProjected(LinearUnit unit) {
        return CoordinateReferenceSystems.mkProjected(CrsId.UNDEFINED.getCode(), unit);
    }

    public static Geographic2DCoordinateReferenceSystem mkGeographic(AngularUnit unit) {
        return new Geographic2DCoordinateReferenceSystem(CrsId.UNDEFINED, "Generic 2D Projected", new EllipsoidalCoordinateSystem2D(new GeodeticLatitudeCSAxis("Lat", unit), new GeodeticLongitudeCSAxis("Lon", unit)));
    }

    public static LinearCoordinateReferenceSystem mkLinear(LinearUnit unit) {
        return new LinearCoordinateReferenceSystem("measure", new MeasureStraightLineAxis("M", unit));
    }

    public static VerticalCoordinateReferenceSystem mkVertical(LinearUnit unit) {
        return new VerticalCoordinateReferenceSystem(CrsId.UNDEFINED, "vertical", VerticalDatum.UNKNOWN_VERTICAL_DATUM, new VerticalStraightLineAxis("Z", unit));
    }

    public static <P extends Position, R extends P> CompoundCoordinateReferenceSystem<R> combine(CoordinateReferenceSystem<P> base, SingleCoordinateReferenceSystem ods, Class<R> resultCSPtype) {
        return CoordinateReferenceSystems.combine(base, ods);
    }

    public static <P extends Position, R extends P> CompoundCoordinateReferenceSystem<R> addLinearSystem(CoordinateReferenceSystem<P> base, Class<R> resultCSPtype, LinearUnit unit) {
        return CoordinateReferenceSystems.combine(base, CoordinateReferenceSystems.mkLinear(unit), resultCSPtype);
    }

    public static <P extends Position, R extends P> CompoundCoordinateReferenceSystem<R> addVerticalSystem(CoordinateReferenceSystem<P> base, Class<R> resultCSPtype, LinearUnit unit) {
        return CoordinateReferenceSystems.combine(base, CoordinateReferenceSystems.mkVertical(unit), resultCSPtype);
    }

    public static <P extends Position> CompoundCoordinateReferenceSystem<?> combine(CoordinateReferenceSystem<P> base, SingleCoordinateReferenceSystem ods) {
        if (base instanceof CompoundCoordinateReferenceSystem) {
            List<SingleCoordinateReferenceSystem<?>> components = ((CompoundCoordinateReferenceSystem)base).getComponents();
            ArrayList<SingleCoordinateReferenceSystem> nc = new ArrayList<SingleCoordinateReferenceSystem>();
            nc.addAll(components);
            nc.add(ods);
            return new CompoundCoordinateReferenceSystem(base.getName() + "+" + ods.getName(), nc.toArray(new SingleCoordinateReferenceSystem[nc.size()]));
        }
        if (base instanceof SingleCoordinateReferenceSystem) {
            SingleCoordinateReferenceSystem single = (SingleCoordinateReferenceSystem)base;
            return new CompoundCoordinateReferenceSystem(single.getName() + "+" + ods.getName(), single, ods);
        }
        throw new UnsupportedOperationException("Unsupported type of coordinate reference system");
    }

    public static <P extends Position> CompoundCoordinateReferenceSystem<?> addLinearSystem(CoordinateReferenceSystem<P> base, LinearUnit unit) {
        return CoordinateReferenceSystems.combine(base, CoordinateReferenceSystems.mkLinear(unit));
    }

    public static <P extends Position> CompoundCoordinateReferenceSystem<?> addVerticalSystem(CoordinateReferenceSystem<P> base, LinearUnit unit) {
        return CoordinateReferenceSystems.combine(base, CoordinateReferenceSystems.mkVertical(unit));
    }

    public static <P extends Position> boolean hasAxisOrder(CoordinateReferenceSystem<P> crs, int order) {
        CoordinateSystemAxis[] axes;
        for (CoordinateSystemAxis axis : axes = crs.getCoordinateSystem().getAxes()) {
            if (axis.getNormalOrder() != order) continue;
            return true;
        }
        return false;
    }

    public static <P extends Position> boolean hasVerticalAxis(CoordinateReferenceSystem<P> crs) {
        return CoordinateReferenceSystems.hasAxisOrder(crs, 2);
    }

    public static <P extends Position> boolean hasMeasureAxis(CoordinateReferenceSystem<P> crs) {
        return CoordinateReferenceSystems.hasAxisOrder(crs, 3);
    }
}

