/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.GeometryVisitor;
import org.geolatte.geom.LineSegment;
import org.geolatte.geom.LineSegments;
import org.geolatte.geom.Linear;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.Simple;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class LineString<P extends Position>
extends Geometry<P>
implements Linear<P>,
Simple {
    public LineString(CoordinateReferenceSystem<P> crs) {
        super(crs);
    }

    protected LineString(LineString<P> base) {
        super(base.getPositions(), base.getCoordinateReferenceSystem());
    }

    public LineString(PositionSequence<P> positions, CoordinateReferenceSystem<P> crs) {
        super(positions, crs);
        if (positions.size() != 0 && positions.size() < 2) {
            throw new IllegalArgumentException("Require at least two points for a linestring");
        }
    }

    @Override
    public P getStartPosition() {
        return this.getPositionN(0);
    }

    @Override
    public P getEndPosition() {
        return this.getPositionN(this.getNumPositions() - 1);
    }

    public boolean isClosed() {
        return !this.isEmpty() && ((Position)this.getStartPosition()).equals(this.getEndPosition());
    }

    public boolean isRing() {
        return !this.isEmpty() && this.isClosed();
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.LINESTRING;
    }

    @Override
    public void accept(GeometryVisitor<P> visitor) {
        visitor.visit(this);
    }

    Iterable<LineSegment<P>> lineSegments() {
        return new LineSegments(this.getPositions());
    }
}

