/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.GeometryType;
import org.geolatte.geom.LineString;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class LinearRing<P extends Position>
extends LineString<P> {
    public LinearRing(LineString<P> lineString) {
        super(lineString);
        this.checkIsClosed();
    }

    public LinearRing(CoordinateReferenceSystem<P> crs) {
        super(crs);
    }

    public LinearRing(PositionSequence<P> points, CoordinateReferenceSystem<P> crs) {
        super(points, crs);
        this.checkIsClosed();
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.LINEARRING;
    }

    private void checkIsClosed() {
        if (this.isEmpty() || this.isClosed() && this.getNumPositions() > 3) {
            return;
        }
        throw new IllegalArgumentException("Cannot create a LinearRing. PointSequence is not closed or contains < 4 points.");
    }

    @Override
    public <Q extends Position> LinearRing<Q> as(Class<Q> castToType) {
        this.checkCast(castToType);
        return this;
    }
}

