/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.codec.HANAWktGeometryToken;
import org.geolatte.geom.codec.PostgisWktVariant;
import org.geolatte.geom.codec.WktKeywordToken;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;

class HANAWktVariant
extends PostgisWktVariant {
    private static final List<HANAWktGeometryToken> GEOMETRIES = new ArrayList<HANAWktGeometryToken>();
    private static final Set<WktKeywordToken> KEYWORDS;

    protected HANAWktVariant() {
    }

    private static void add(GeometryType type, boolean isMeasured, boolean is3D, String word) {
        GEOMETRIES.add(new HANAWktGeometryToken(word, type, isMeasured, is3D));
    }

    @Override
    public String wordFor(Geometry geometry, boolean ignoreMeasureMarker) {
        for (HANAWktGeometryToken candidate : GEOMETRIES) {
            if (!this.sameGeometryType(candidate, geometry) || !this.hasSameMeasuredAndZAxisSuffixInWkt(candidate, geometry, ignoreMeasureMarker)) continue;
            return candidate.getPattern().toString();
        }
        throw new IllegalStateException(String.format("Geometry type %s not recognized.", geometry.getClass().getName()));
    }

    @Override
    protected Set<WktKeywordToken> getWktKeywords() {
        return KEYWORDS;
    }

    private boolean hasSameMeasuredAndZAxisSuffixInWkt(HANAWktGeometryToken candidate, Geometry<?> geometry, boolean ignoreMeasureMarker) {
        if (ignoreMeasureMarker) {
            return !candidate.isMeasured();
        }
        CoordinateReferenceSystem<?> crs = geometry.getCoordinateReferenceSystem();
        if (CoordinateReferenceSystems.hasMeasureAxis(crs)) {
            if (CoordinateReferenceSystems.hasVerticalAxis(crs)) {
                return candidate.isMeasured() && candidate.is3D();
            }
            return candidate.isMeasured() && !candidate.is3D();
        }
        if (CoordinateReferenceSystems.hasVerticalAxis(crs)) {
            return !candidate.isMeasured() && candidate.is3D();
        }
        return !candidate.isMeasured() && !candidate.is3D();
    }

    static {
        HANAWktVariant.add(GeometryType.POINT, false, false, "POINT");
        HANAWktVariant.add(GeometryType.POINT, true, false, "POINT M");
        HANAWktVariant.add(GeometryType.POINT, false, true, "POINT Z");
        HANAWktVariant.add(GeometryType.POINT, true, true, "POINT ZM");
        HANAWktVariant.add(GeometryType.LINESTRING, true, false, "LINESTRING M");
        HANAWktVariant.add(GeometryType.LINESTRING, false, false, "LINESTRING");
        HANAWktVariant.add(GeometryType.LINESTRING, true, true, "LINESTRING ZM");
        HANAWktVariant.add(GeometryType.LINESTRING, false, true, "LINESTRING Z");
        HANAWktVariant.add(GeometryType.POLYGON, false, false, "POLYGON");
        HANAWktVariant.add(GeometryType.POLYGON, true, false, "POLYGON M");
        HANAWktVariant.add(GeometryType.POLYGON, false, true, "POLYGON Z");
        HANAWktVariant.add(GeometryType.POLYGON, true, true, "POLYGON ZM");
        HANAWktVariant.add(GeometryType.MULTIPOINT, true, false, "MULTIPOINT M");
        HANAWktVariant.add(GeometryType.MULTIPOINT, false, false, "MULTIPOINT");
        HANAWktVariant.add(GeometryType.MULTIPOINT, true, true, "MULTIPOINT ZM");
        HANAWktVariant.add(GeometryType.MULTIPOINT, false, true, "MULTIPOINT Z");
        HANAWktVariant.add(GeometryType.MULTILINESTRING, false, false, "MULTILINESTRING");
        HANAWktVariant.add(GeometryType.MULTILINESTRING, true, false, "MULTILINESTRING M");
        HANAWktVariant.add(GeometryType.MULTILINESTRING, false, true, "MULTILINESTRING Z");
        HANAWktVariant.add(GeometryType.MULTILINESTRING, true, true, "MULTILINESTRING ZM");
        HANAWktVariant.add(GeometryType.MULTIPOLYGON, false, false, "MULTIPOLYGON");
        HANAWktVariant.add(GeometryType.MULTIPOLYGON, true, false, "MULTIPOLYGON M");
        HANAWktVariant.add(GeometryType.MULTIPOLYGON, false, true, "MULTIPOLYGON Z");
        HANAWktVariant.add(GeometryType.MULTIPOLYGON, true, true, "MULTIPOLYGON ZM");
        HANAWktVariant.add(GeometryType.GEOMETRYCOLLECTION, false, false, "GEOMETRYCOLLECTION");
        HANAWktVariant.add(GeometryType.GEOMETRYCOLLECTION, true, false, "GEOMETRYCOLLECTION M");
        HANAWktVariant.add(GeometryType.GEOMETRYCOLLECTION, false, true, "GEOMETRYCOLLECTION Z");
        HANAWktVariant.add(GeometryType.GEOMETRYCOLLECTION, true, true, "GEOMETRYCOLLECTION ZM");
        HashSet<WktKeywordToken> allTokens = new HashSet<WktKeywordToken>();
        allTokens.addAll(GEOMETRIES);
        allTokens.add(EMPTY);
        KEYWORDS = Collections.unmodifiableSet(allTokens);
    }
}

