/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.codec.WktEmptyGeometryToken;
import org.geolatte.geom.codec.WktGeometryToken;
import org.geolatte.geom.codec.WktKeywordToken;
import org.geolatte.geom.codec.WktVariant;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CoordinateReferenceSystems;

class PostgisWktVariant
extends WktVariant {
    protected static final WktEmptyGeometryToken EMPTY = new WktEmptyGeometryToken();
    private static final List<WktGeometryToken> GEOMETRIES = new ArrayList<WktGeometryToken>();
    private static final Set<WktKeywordToken> KEYWORDS;

    protected PostgisWktVariant() {
        super('(', ')', ',');
    }

    private static void add(GeometryType type, boolean isMeasured, String word) {
        GEOMETRIES.add(new WktGeometryToken(word, type, isMeasured));
    }

    public String wordFor(Geometry geometry, boolean ignoreMeasureMarker) {
        for (WktGeometryToken candidate : GEOMETRIES) {
            if (!this.sameGeometryType(candidate, geometry) || !this.hasSameMeasuredSuffixInWkt(candidate, geometry, ignoreMeasureMarker)) continue;
            return candidate.getPattern().toString();
        }
        throw new IllegalStateException(String.format("Geometry type %s not recognized.", geometry.getClass().getName()));
    }

    @Override
    protected Set<WktKeywordToken> getWktKeywords() {
        return KEYWORDS;
    }

    public WktKeywordToken getEmpty() {
        return EMPTY;
    }

    protected boolean sameGeometryType(WktGeometryToken token, Geometry geometry) {
        return token.getType() == geometry.getGeometryType() || token.getType().equals((Object)GeometryType.LINESTRING) && geometry.getGeometryType().equals((Object)GeometryType.LINEARRING);
    }

    private boolean hasSameMeasuredSuffixInWkt(WktGeometryToken candidate, Geometry geometry, boolean ignoreMeasureMarker) {
        if (ignoreMeasureMarker) {
            return !candidate.isMeasured();
        }
        CoordinateReferenceSystem crs = geometry.getCoordinateReferenceSystem();
        if (CoordinateReferenceSystems.hasMeasureAxis(crs) && !CoordinateReferenceSystems.hasVerticalAxis(crs)) {
            return candidate.isMeasured();
        }
        return !candidate.isMeasured();
    }

    static {
        PostgisWktVariant.add(GeometryType.POINT, false, "POINT");
        PostgisWktVariant.add(GeometryType.POINT, true, "POINTM");
        PostgisWktVariant.add(GeometryType.LINESTRING, true, "LINESTRINGM");
        PostgisWktVariant.add(GeometryType.LINESTRING, false, "LINESTRING");
        PostgisWktVariant.add(GeometryType.POLYGON, false, "POLYGON");
        PostgisWktVariant.add(GeometryType.POLYGON, true, "POLYGONM");
        PostgisWktVariant.add(GeometryType.MULTIPOINT, true, "MULTIPOINTM");
        PostgisWktVariant.add(GeometryType.MULTIPOINT, false, "MULTIPOINT");
        PostgisWktVariant.add(GeometryType.MULTILINESTRING, false, "MULTILINESTRING");
        PostgisWktVariant.add(GeometryType.MULTILINESTRING, true, "MULTILINESTRINGM");
        PostgisWktVariant.add(GeometryType.MULTIPOLYGON, false, "MULTIPOLYGON");
        PostgisWktVariant.add(GeometryType.MULTIPOLYGON, true, "MULTIPOLYGONM");
        PostgisWktVariant.add(GeometryType.GEOMETRYCOLLECTION, false, "GEOMETRYCOLLECTION");
        PostgisWktVariant.add(GeometryType.GEOMETRYCOLLECTION, true, "GEOMETRYCOLLECTIONM");
        HashSet<WktKeywordToken> allTokens = new HashSet<WktKeywordToken>();
        allTokens.addAll(GEOMETRIES);
        allTokens.add(EMPTY);
        KEYWORDS = Collections.unmodifiableSet(allTokens);
    }
}

