/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.LineString;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.codec.db.oracle.AbstractSDODecoder;
import org.geolatte.geom.codec.db.oracle.ElemInfo;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.TypeGeometry;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class LineStringSdoDecoder
extends AbstractSDODecoder {
    @Override
    public boolean accepts(SDOGeometry nativeGeom) {
        return nativeGeom.getGType().getTypeGeometry() == TypeGeometry.LINE;
    }

    @Override
    protected Geometry<?> internalDecode(SDOGeometry nativeGeom) {
        CoordinateReferenceSystem<?> crs = this.getCoordinateReferenceSystem(nativeGeom);
        ElemInfo info = nativeGeom.getInfo();
        PositionSequence<?> cs = null;
        int i = 0;
        while (i < info.getSize()) {
            if (info.getElementType(i).isCompound()) {
                int numCompounds = info.getNumCompounds(i);
                cs = this.add(cs, this.getCompoundCSeq(i + 1, i + numCompounds, nativeGeom));
                i += 1 + numCompounds;
                continue;
            }
            cs = this.add(cs, this.getElementCSeq(i, nativeGeom, false, crs));
            ++i;
        }
        return new LineString(cs, crs);
    }
}

