/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs.trans;

import org.geolatte.geom.crs.CoordinateReferenceSystems;
import org.geolatte.geom.crs.Datum;
import org.geolatte.geom.crs.GeographicCoordinateReferenceSystem;
import org.geolatte.geom.crs.trans.ConcatenatedOperation;
import org.geolatte.geom.crs.trans.CoordinateOperation;
import org.geolatte.geom.crs.trans.Geographic3DTo2DConversion;
import org.geolatte.geom.crs.trans.GeographicToGeocentricConversion;
import org.geolatte.geom.crs.trans.PositionVectorTransformation;

public class CoordinateOperations {
    public static CoordinateOperation positionVectorTransformation2D(GeographicCoordinateReferenceSystem source, GeographicCoordinateReferenceSystem target) {
        CoordinateOperation datumTransformation = CoordinateOperations.positionVectorTransformation(source.getDatum(), target.getDatum());
        return new ConcatenatedOperation.Builder().reverse(new Geographic3DTo2DConversion()).forward(new GeographicToGeocentricConversion(source)).forward(datumTransformation).reverse(new GeographicToGeocentricConversion(target)).forward(new Geographic3DTo2DConversion()).build();
    }

    public static CoordinateOperation positionVectorTransformation3D(GeographicCoordinateReferenceSystem source, GeographicCoordinateReferenceSystem target) {
        CoordinateOperation datumTransformation = CoordinateOperations.positionVectorTransformation(source.getDatum(), target.getDatum());
        return new ConcatenatedOperation.Builder().forward(new GeographicToGeocentricConversion(source)).forward(datumTransformation).reverse(new GeographicToGeocentricConversion(target)).build();
    }

    public static CoordinateOperation positionVectorTransformation(Datum source, Datum target) {
        if (source == target) {
            return new IdentityOp(3);
        }
        if (CoordinateReferenceSystems.WGS84.getDatum().equals(source)) {
            if (target.getToWGS84().length == 0) {
                throw new IllegalArgumentException("Source and target datums must have a ToWGS84 parameters ");
            }
            return PositionVectorTransformation.fromTOWGS84(target.getToWGS84()).reverse();
        }
        if (CoordinateReferenceSystems.WGS84.getDatum().equals(target)) {
            if (source.getToWGS84().length == 0) {
                throw new IllegalArgumentException("Source and target datums must have a ToWGS84 parameters ");
            }
            return PositionVectorTransformation.fromTOWGS84(source.getToWGS84());
        }
        if (source.getToWGS84().length == 0 || target.getToWGS84().length == 0) {
            throw new IllegalArgumentException("Source and target datums must have a ToWGS84 parameters ");
        }
        return PositionVectorTransformation.fromTOWGS84(source.getToWGS84()).appendReverse(PositionVectorTransformation.fromTOWGS84(target.getToWGS84()));
    }

    public static CoordinateOperation identity(int dim) {
        return new IdentityOp(dim);
    }

    private static class IdentityOp
    implements CoordinateOperation {
        private final int dimension;

        IdentityOp(int dimension) {
            this.dimension = dimension;
        }

        @Override
        public boolean isReversible() {
            return true;
        }

        @Override
        public int inCoordinateDimension() {
            return this.dimension;
        }

        @Override
        public int outCoordinateDimension() {
            return this.dimension;
        }

        @Override
        public void forward(double[] inCoordinate, double[] outCoordinate) {
            System.arraycopy(inCoordinate, 0, outCoordinate, 0, this.dimension);
        }

        @Override
        public void reverse(double[] inCoordinate, double[] outCoordinate) {
            this.forward(inCoordinate, outCoordinate);
        }
    }
}

