/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs.trans;

import org.geolatte.geom.DecimalDegree;
import org.geolatte.geom.crs.trans.CoordinateOperation;
import org.geolatte.geom.crs.trans.WithEpsgGOperationMethod;

public class PositionVectorTransformation
implements CoordinateOperation,
WithEpsgGOperationMethod {
    private final double tx;
    private final double ty;
    private final double tz;
    private final double rx;
    private final double ry;
    private final double rz;
    private final double m;

    public static PositionVectorTransformation fromTOWGS84(double[] params) {
        return new PositionVectorTransformation(params[0], params[1], params[2], params[3], params[4], params[5], params[6]);
    }

    public PositionVectorTransformation(double tx, double ty, double tz, double rx, double ry, double rz, double ds) {
        this.tx = tx;
        this.ty = ty;
        this.tz = tz;
        this.rx = DecimalDegree.secondsToRadians(rx);
        this.ry = DecimalDegree.secondsToRadians(ry);
        this.rz = DecimalDegree.secondsToRadians(rz);
        this.m = this.ppmToScaleFactor(ds);
    }

    private double ppmToScaleFactor(double ds) {
        return 1.0 + ds * 1.0E-6;
    }

    @Override
    public boolean isReversible() {
        return true;
    }

    @Override
    public int inCoordinateDimension() {
        return 3;
    }

    @Override
    public int outCoordinateDimension() {
        return 3;
    }

    @Override
    public void forward(double[] inCoordinate, double[] outCoordinate) {
        double sx = inCoordinate[0];
        double sy = inCoordinate[1];
        double sz = inCoordinate[2];
        outCoordinate[0] = this.m * (sx - this.rz * sy + this.ry * sz) + this.tx;
        outCoordinate[1] = this.m * (this.rz * sx + sy - this.rx * sz) + this.ty;
        outCoordinate[2] = this.m * (-this.ry * sx + this.rx * sy + sz) + this.tz;
    }

    @Override
    public void reverse(double[] inCoordinate, double[] outCoordinate) {
        double sx = inCoordinate[0];
        double sy = inCoordinate[1];
        double sz = inCoordinate[2];
        outCoordinate[0] = 1.0 / this.m * (sx + this.rz * sy - this.ry * sz) - this.tx;
        outCoordinate[1] = 1.0 / this.m * (-this.rz * sx + sy + this.rx * sz) - this.ty;
        outCoordinate[2] = 1.0 / this.m * (this.ry * sx - this.rx * sy + sz) - this.tz;
    }

    @Override
    public String getMethodId() {
        return "1033";
    }
}

