/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.generator;

import java.util.Random;
import org.geolatte.geom.Envelope;
import org.geolatte.geom.Position;
import org.geolatte.geom.Positions;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class PositionGenerator {
    public static <P extends Position> P positionWithin(Envelope<P> bbox, Random rnd) {
        P ll = bbox.lowerLeft();
        P ur = bbox.upperRight();
        CoordinateReferenceSystem<P> crs = bbox.getCoordinateReferenceSystem();
        double[] coords = new double[crs.getCoordinateDimension()];
        for (int i = 0; i < coords.length; ++i) {
            coords[i] = ((Position)ll).getCoordinate(i) + (((Position)ur).getCoordinate(i) - ((Position)ll).getCoordinate(i)) * rnd.nextDouble();
        }
        return Positions.mkPosition(crs, coords);
    }
}

