/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import java.util.ArrayList;
import java.util.LinkedList;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.MultiPolygon;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.codec.db.oracle.AbstractSDODecoder;
import org.geolatte.geom.codec.db.oracle.ElemInfo;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.TypeGeometry;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class MultiPolygonSdoDecoder
extends AbstractSDODecoder {
    @Override
    public boolean accepts(SDOGeometry nativeGeom) {
        return nativeGeom.getGType().getTypeGeometry() == TypeGeometry.MULTIPOLYGON;
    }

    @Override
    Geometry<?> internalDecode(SDOGeometry sdoGeom) {
        int numCompounds;
        CoordinateReferenceSystem<?> crs = this.getCoordinateReferenceSystem(sdoGeom);
        LinkedList holes = new LinkedList();
        ArrayList polygons = new ArrayList();
        ElemInfo info = sdoGeom.getInfo();
        LinearRing shell = null;
        for (int i = 0; i < info.getSize(); i += 1 + numCompounds) {
            PositionSequence<?> cs = null;
            numCompounds = 0;
            if (info.getElementType(i).isCompound()) {
                numCompounds = info.getNumCompounds(i);
                cs = this.add(cs, this.getCompoundCSeq(i + 1, i + numCompounds, sdoGeom));
            } else {
                cs = this.add(cs, this.getElementCSeq(i, sdoGeom, false, crs));
            }
            if (info.getElementType(i).isInteriorRing()) {
                LinearRing lr = new LinearRing(cs, crs);
                holes.addLast(lr);
                continue;
            }
            if (shell != null) {
                holes.addFirst(shell);
                Polygon polygon = new Polygon(holes.toArray(new LinearRing[holes.size()]));
                polygons.add(polygon);
                shell = null;
            }
            shell = new LinearRing(cs, crs);
            holes = new LinkedList();
        }
        if (shell != null) {
            holes.addFirst(shell);
            Polygon polygon = new Polygon(holes.toArray(new LinearRing[holes.size()]));
            polygons.add(polygon);
        }
        return new MultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
    }
}

