/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.sqlserver;

import java.util.ArrayList;
import java.util.List;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.codec.db.Encoder;
import org.geolatte.geom.codec.db.sqlserver.CountingPositionSequenceBuilder;
import org.geolatte.geom.codec.db.sqlserver.Figure;
import org.geolatte.geom.codec.db.sqlserver.Shape;
import org.geolatte.geom.codec.db.sqlserver.SqlServerGeometry;
import org.geolatte.geom.crs.CoordinateReferenceSystems;

abstract class AbstractSqlServerEncoder
implements Encoder<SqlServerGeometry> {
    AbstractSqlServerEncoder() {
    }

    @Override
    public <P extends Position, G extends Geometry<P>> SqlServerGeometry encode(G geom) {
        SqlServerGeometry nativeGeom = new SqlServerGeometry();
        if (geom.getSRID() > 0) {
            nativeGeom.setCoordinateReferenceSystem(geom.getCoordinateReferenceSystem());
        }
        nativeGeom.setIsValid();
        if (CoordinateReferenceSystems.hasMeasureAxis(geom.getCoordinateReferenceSystem())) {
            nativeGeom.setHasMValues();
        }
        if (CoordinateReferenceSystems.hasVerticalAxis(geom.getCoordinateReferenceSystem())) {
            nativeGeom.setHasZValues();
        }
        CountingPositionSequenceBuilder<P> coordinates = new CountingPositionSequenceBuilder<P>(geom.getCoordinateReferenceSystem());
        ArrayList<Figure> figures = new ArrayList<Figure>();
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        this.encode(geom, -1, coordinates, figures, shapes);
        this.encodePoints(nativeGeom, coordinates.toPositionSequence());
        this.encodeFigures(nativeGeom, figures);
        this.encodeShapes(nativeGeom, shapes);
        return nativeGeom;
    }

    protected abstract void encode(Geometry<?> var1, int var2, CountingPositionSequenceBuilder<?> var3, List<Figure> var4, List<Shape> var5);

    protected void encodeShapes(SqlServerGeometry nativeGeom, List<Shape> shapes) {
        nativeGeom.setNumberOfShapes(shapes.size());
        for (int i = 0; i < shapes.size(); ++i) {
            nativeGeom.setShape(i, shapes.get(i));
        }
    }

    protected void encodeFigures(SqlServerGeometry nativeGeom, List<Figure> figures) {
        nativeGeom.setNumberOfFigures(figures.size());
        for (int i = 0; i < figures.size(); ++i) {
            nativeGeom.setFigure(i, figures.get(i));
        }
    }

    protected void encodePoints(SqlServerGeometry nativeGeom, PositionSequence<?> coordinates) {
        nativeGeom.setNumberOfPoints(coordinates.size());
        nativeGeom.allocateMValueArray();
        nativeGeom.allocateZValueArray();
        for (int i = 0; i < coordinates.size(); ++i) {
            this.setCoordinate(nativeGeom, i, coordinates);
        }
    }

    protected void setCoordinate(SqlServerGeometry nativeGeom, int idx, PositionSequence<?> coordinates) {
        nativeGeom.setCoordinate(idx, coordinates);
    }
}

