/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.sqlserver;

import org.geolatte.geom.Position;
import org.geolatte.geom.PositionSequence;
import org.geolatte.geom.PositionSequenceBuilder;
import org.geolatte.geom.PositionSequenceBuilders;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class CountingPositionSequenceBuilder<P extends Position>
implements PositionSequenceBuilder<P> {
    private final PositionSequenceBuilder<P> delegate;
    private final int dim;
    int num = 0;

    public CountingPositionSequenceBuilder(CoordinateReferenceSystem<P> crs) {
        this.delegate = PositionSequenceBuilders.variableSized(crs.getPositionClass());
        this.dim = crs.getCoordinateDimension();
    }

    @Override
    public PositionSequenceBuilder<P> add(double ... coordinates) {
        ++this.num;
        return this.delegate.add(coordinates);
    }

    @Override
    public PositionSequenceBuilder<P> add(P position) {
        ++this.num;
        return this.delegate.add(position);
    }

    @Override
    public PositionSequence<P> toPositionSequence() {
        return this.delegate.toPositionSequence();
    }

    @Override
    public int getNumAdded() {
        return this.num;
    }

    public int getCoordinateDimension() {
        return this.dim;
    }
}

