/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.crs;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrsParameter
implements Serializable {
    private static final long serialVersionUID = 6884205871950410216L;
    private final String name;
    private final double value;

    public static Map<String, CrsParameter> toMap(List<CrsParameter> params) {
        HashMap<String, CrsParameter> map = new HashMap<String, CrsParameter>();
        for (CrsParameter p : params) {
            map.put(p.getName(), p);
        }
        return map;
    }

    public CrsParameter(String name, double value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CrsParameter that = (CrsParameter)o;
        if (Double.compare(that.value, this.value) != 0) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        long temp = this.value != 0.0 ? Double.doubleToLongBits(this.value) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "CrsParameter{name='" + this.name + '\'' + ", value=" + this.value + '}';
    }
}

