/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.Position;
import org.geolatte.geom.Positions;
import org.geolatte.geom.crs.CoordinateReferenceSystem;

public class Box<P extends Position> {
    private final CoordinateReferenceSystem<P> crs;
    private final P lowerLeft;
    private final P upperRight;

    public Box(CoordinateReferenceSystem<P> crs) {
        this.crs = crs;
        this.lowerLeft = Positions.mkPosition(crs, new double[0]);
        this.upperRight = this.lowerLeft;
    }

    public Box(P lowerLeft, P upperRight, CoordinateReferenceSystem<P> crs) {
        if (crs == null) {
            throw new IllegalArgumentException("Null CRS argument not allowed");
        }
        for (int i = 0; i < ((Position)lowerLeft).getCoordinateDimension(); ++i) {
            if (!(((Position)lowerLeft).getCoordinate(i) > ((Position)upperRight).getCoordinate(i))) continue;
            throw new IllegalArgumentException("Lowerleft needs to be smaller than upperRight");
        }
        this.crs = crs;
        this.lowerLeft = lowerLeft;
        this.upperRight = upperRight;
    }

    public CoordinateReferenceSystem<P> getCoordinateReferenceSystem() {
        return this.crs;
    }

    public P lowerLeft() {
        return this.lowerLeft;
    }

    public P upperRight() {
        return this.upperRight;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getCoordinateReferenceSystem().getCrsId().toString());
        builder.append("Box LL: ").append(((Position)this.lowerLeft).toString()).append(" - UR: ").append(((Position)this.upperRight).toString());
        return builder.toString();
    }

    public Box<P> union(Box<P> other) {
        if (other == null || other.isEmpty()) {
            return this;
        }
        if (!this.getCoordinateReferenceSystem().equals(other.getCoordinateReferenceSystem())) {
            throw new IllegalArgumentException("Boxs have different CRS.");
        }
        double[] lowerLeft = new double[this.getCoordinateDimension()];
        double[] upperRight = new double[this.getCoordinateDimension()];
        for (int i = 0; i < this.getCoordinateDimension(); ++i) {
            lowerLeft[i] = Math.min(((Position)this.lowerLeft).getCoordinate(i), ((Position)other.lowerLeft).getCoordinate(i));
            upperRight[i] = Math.max(((Position)this.upperRight).getCoordinate(i), ((Position)other.upperRight).getCoordinate(i));
        }
        return new Box<P>(Positions.mkPosition(this.crs, lowerLeft), Positions.mkPosition(this.crs, upperRight), this.crs);
    }

    public Box<P> intersect(Box<P> other) {
        if (other == null || other.isEmpty()) {
            return this;
        }
        if (!this.getCoordinateReferenceSystem().equals(other.getCoordinateReferenceSystem())) {
            throw new IllegalArgumentException("Boxs have different CRS.");
        }
        double[] lowerLeft = new double[this.getCoordinateDimension()];
        double[] upperRight = new double[this.getCoordinateDimension()];
        for (int i = 0; i < this.getCoordinateDimension(); ++i) {
            if (((Position)this.lowerLeft).getCoordinate(i) > ((Position)other.upperRight).getCoordinate(i) || ((Position)this.upperRight).getCoordinate(i) < ((Position)other.lowerLeft).getCoordinate(i)) {
                return this.mkEmpty();
            }
            lowerLeft[i] = Math.max(((Position)this.lowerLeft).getCoordinate(i), ((Position)other.lowerLeft).getCoordinate(i));
            upperRight[i] = Math.min(((Position)this.upperRight).getCoordinate(i), ((Position)other.upperRight).getCoordinate(i));
        }
        return new Box<P>(Positions.mkPosition(this.crs, lowerLeft), Positions.mkPosition(this.crs, upperRight), this.crs);
    }

    private Box<P> mkEmpty() {
        P pos = Positions.mkPosition(this.crs, new double[0]);
        return new Box<P>(pos, pos, this.crs);
    }

    public static <P extends Position> Box<P> mkEmpty(CoordinateReferenceSystem<P> crs) {
        P pos = Positions.mkPosition(crs, new double[0]);
        return new Box<P>(pos, pos, crs);
    }

    public int getCoordinateDimension() {
        return this.crs.getCoordinateDimension();
    }

    public boolean isEmpty() {
        return ((Position)this.lowerLeft).isEmpty() && ((Position)this.upperRight).isEmpty();
    }

    public boolean within(Box<P> other) {
        if (other == null || other.isEmpty()) {
            return false;
        }
        if (!this.getCoordinateReferenceSystem().equals(other.getCoordinateReferenceSystem())) {
            throw new IllegalArgumentException("Boxs have different CRS.");
        }
        for (int i = 0; i < this.getCoordinateDimension(); ++i) {
            if (!(((Position)this.lowerLeft).getCoordinate(i) < ((Position)other.lowerLeft).getCoordinate(i)) && !(((Position)this.upperRight).getCoordinate(i) > ((Position)other.upperRight).getCoordinate(i))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Box other) {
        return other.within(this);
    }

    public boolean contains(P p) {
        if (!p.getClass().equals(this.getCoordinateReferenceSystem().getPositionClass())) {
            throw new IllegalArgumentException("Position and envelope of different types");
        }
        if (this.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.getCoordinateDimension(); ++i) {
            if (!(((Position)p).getCoordinate(i) < ((Position)this.lowerLeft).getCoordinate(i)) && !(((Position)p).getCoordinate(i) > ((Position)this.upperRight).getCoordinate(i))) continue;
            return false;
        }
        return true;
    }

    public boolean intersects(Box<P> other) {
        if (this.isEmpty() || other.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.getCoordinateDimension(); ++i) {
            if (!(((Position)this.lowerLeft).getCoordinate(i) > ((Position)other.upperRight).getCoordinate(i)) && !(((Position)this.upperRight).getCoordinate(i) < ((Position)other.lowerLeft).getCoordinate(i))) continue;
            return false;
        }
        return true;
    }

    public <Q extends Position> Box<Q> as(Class<Q> castToType) {
        if (!castToType.isAssignableFrom(this.crs.getPositionClass())) {
            throw new ClassCastException(String.format("Can't cast a %s to a %s", this.crs.getPositionClass().getName(), castToType.getName()));
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Box envelope = (Box)o;
        if (this.crs != null ? !this.crs.equals(envelope.crs) : envelope.crs != null) {
            return false;
        }
        if (this.isEmpty() && envelope.isEmpty()) {
            return true;
        }
        if (this.lowerLeft != null ? !((Position)this.lowerLeft).equals(envelope.lowerLeft) : envelope.lowerLeft != null) {
            return false;
        }
        return !(this.upperRight != null ? !((Position)this.upperRight).equals(envelope.upperRight) : envelope.upperRight != null);
    }

    public int hashCode() {
        int result = this.crs != null ? this.crs.hashCode() : 0;
        result = 31 * result + (this.lowerLeft != null ? ((Position)this.lowerLeft).hashCode() : 0);
        result = 31 * result + (this.upperRight != null ? ((Position)this.upperRight).hashCode() : 0);
        return result;
    }
}

