/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.WkbDialect;

class Sfa121WkbDialect
extends WkbDialect {
    static final Sfa121WkbDialect INSTANCE = new Sfa121WkbDialect();

    Sfa121WkbDialect() {
    }

    @Override
    protected <P extends Position> Long geometryTypeCode(Geometry<P> geometry) {
        Long base = super.geometryTypeCode(geometry);
        if (geometry.hasZ()) {
            base = base + 1000L;
        }
        if (geometry.hasM()) {
            base = base + 2000L;
        }
        return base;
    }

    @Override
    GeometryType parseType(long tpe) {
        long t = tpe % 1000L;
        return super.parseType(t);
    }

    @Override
    boolean hasZ(long tpe) {
        return tpe > 1000L && tpe < 2000L || tpe > 3000L;
    }

    @Override
    boolean hasM(long tpe) {
        return tpe > 2000L;
    }
}

