/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import java.math.BigDecimal;
import java.sql.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geolatte.geom.codec.db.oracle.CompoundElement;
import org.geolatte.geom.codec.db.oracle.Element;
import org.geolatte.geom.codec.db.oracle.ElementType;
import org.geolatte.geom.codec.db.oracle.SDOGType;
import org.geolatte.geom.codec.db.oracle.SDOGeometry;
import org.geolatte.geom.codec.db.oracle.SimpleElement;

class ElemInfo {
    static final String TYPE_NAME = "MDSYS.SDO_ELEM_INFO_ARRAY";
    private BigDecimal[] triplets;

    public ElemInfo(int numTriplets) {
        this.triplets = new BigDecimal[3 * numTriplets];
    }

    ElemInfo(BigDecimal[] elemInfo) {
        this.triplets = elemInfo;
    }

    ElemInfo(Array array) {
        if (array == null) {
            this.triplets = new BigDecimal[0];
            return;
        }
        try {
            this.triplets = (BigDecimal[])array.getArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    BigDecimal[] asRawArray() {
        return this.triplets;
    }

    List<Element> interpret(SDOGType gtype, Double[] ordinates) {
        int numElements = this.triplets.length / 3;
        ElementType[] etypes = new ElementType[numElements];
        int[] offsets = new int[numElements + 1];
        int[] interpretations = new int[numElements];
        for (int idx = 0; idx < numElements; ++idx) {
            offsets[idx] = this.triplets[3 * idx].intValue() - 1;
            int etype = this.triplets[3 * idx + 1].intValue();
            int interp = this.triplets[3 * idx + 2].intValue();
            etypes[idx] = ElementType.parseType(etype, interp);
            interpretations[idx] = interp;
        }
        offsets[numElements] = ordinates.length;
        ArrayList<Element> elements = new ArrayList<Element>();
        int i = 0;
        while (i < etypes.length) {
            if (etypes[i].isCompound()) {
                int numSubElems = interpretations[i];
                ArrayList<Element> subElems = new ArrayList<Element>();
                for (int k = 0; k < numSubElems; ++k) {
                    int ordinateStartIndex = offsets[i + k + 1];
                    int ordinateEndIndex = offsets[i + k + 2];
                    if (k < numSubElems - 1) {
                        ordinateEndIndex += gtype.getDimension();
                    }
                    subElems.add(new SimpleElement(etypes[i + k + 1], Arrays.copyOfRange(ordinates, ordinateStartIndex, ordinateEndIndex)));
                }
                elements.add(new CompoundElement(etypes[i], subElems));
                i += numSubElems + 1;
                continue;
            }
            elements.add(new SimpleElement(etypes[i], Arrays.copyOfRange(ordinates, offsets[i], offsets[i + 1])));
            ++i;
        }
        return elements;
    }

    int getNumTriplets() {
        return this.triplets.length / 3;
    }

    int getOrdinatesOffset(int i) {
        return this.triplets[i * 3].intValue();
    }

    void setOrdinatesOffset(int i, int offset) {
        this.triplets[i * 3] = new BigDecimal(offset);
    }

    void setElement(int i, int ordinatesOffset, ElementType et) {
        if (i > this.getNumTriplets()) {
            throw new RuntimeException("Attempted to set more elements in ElemInfo Array than capacity.");
        }
        this.triplets[i * 3] = new BigDecimal(ordinatesOffset);
        this.triplets[i * 3 + 1] = new BigDecimal(et.getEType());
        this.triplets[i * 3 + 2] = new BigDecimal(et.getInterpretation());
    }

    void setElement(int i, int ordinatesOffset, ElementType et, int numElements) {
        if (i > this.getNumTriplets()) {
            throw new RuntimeException("Attempted to set more elements in ElemInfo Array than capacity.");
        }
        this.triplets[i * 3] = new BigDecimal(ordinatesOffset);
        this.triplets[i * 3 + 1] = new BigDecimal(et.getEType());
        this.triplets[i * 3 + 2] = new BigDecimal(numElements);
    }

    public String toString() {
        return SDOGeometry.arrayToString(this.triplets);
    }

    void addElement(BigDecimal[] element) {
        BigDecimal[] newTriplets = new BigDecimal[this.triplets.length + element.length];
        System.arraycopy(this.triplets, 0, newTriplets, 0, this.triplets.length);
        System.arraycopy(element, 0, newTriplets, this.triplets.length, element.length);
        this.triplets = newTriplets;
    }

    void addElement(ElemInfo element) {
        this.addElement(element.asRawArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ElemInfo elemInfo = (ElemInfo)o;
        return Arrays.equals(this.triplets, elemInfo.triplets);
    }

    public int hashCode() {
        return this.triplets != null ? Arrays.hashCode(this.triplets) : 0;
    }
}

