/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.db.oracle;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Position;
import org.geolatte.geom.codec.db.oracle.AbstractSDODecoder;
import org.geolatte.geom.codec.db.oracle.GeometryCollectionSdoDecoder;
import org.geolatte.geom.codec.db.oracle.LineStringSdoDecoder;
import org.geolatte.geom.codec.db.oracle.MultiLineSdoDecoder;
import org.geolatte.geom.codec.db.oracle.MultiPointSdoDecoder;
import org.geolatte.geom.codec.db.oracle.MultiPolygonSdoDecoder;
import org.geolatte.geom.codec.db.oracle.PointSdoDecoder;
import org.geolatte.geom.codec.db.oracle.PolygonSdoDecoder;

enum SdoGeometryType {
    UNKNOWN_GEOMETRY(0, null){

        @Override
        AbstractSDODecoder createDecoder() {
            throw new UnsupportedOperationException();
        }
    }
    ,
    POINT(1, GeometryType.POINT){

        @Override
        AbstractSDODecoder createDecoder() {
            return new PointSdoDecoder();
        }
    }
    ,
    LINE(2, GeometryType.LINESTRING){

        @Override
        AbstractSDODecoder createDecoder() {
            return new LineStringSdoDecoder();
        }
    }
    ,
    POLYGON(3, GeometryType.POLYGON){

        @Override
        AbstractSDODecoder createDecoder() {
            return new PolygonSdoDecoder();
        }
    }
    ,
    COLLECTION(4, GeometryType.GEOMETRYCOLLECTION){

        @Override
        AbstractSDODecoder createDecoder() {
            return new GeometryCollectionSdoDecoder();
        }
    }
    ,
    MULTIPOINT(5, GeometryType.MULTIPOINT){

        @Override
        AbstractSDODecoder createDecoder() {
            return new MultiPointSdoDecoder();
        }
    }
    ,
    MULTILINE(6, GeometryType.MULTILINESTRING){

        @Override
        AbstractSDODecoder createDecoder() {
            return new MultiLineSdoDecoder();
        }
    }
    ,
    MULTIPOLYGON(7, GeometryType.MULTIPOLYGON){

        @Override
        AbstractSDODecoder createDecoder() {
            return new MultiPolygonSdoDecoder();
        }
    }
    ,
    SOLID(8, null){

        @Override
        AbstractSDODecoder createDecoder() {
            throw new UnsupportedOperationException();
        }
    }
    ,
    MULTISOLID(9, null){

        @Override
        AbstractSDODecoder createDecoder() {
            throw new UnsupportedOperationException();
        }
    };

    private final int gtype;
    private final GeometryType matchingGeometryType;

    private SdoGeometryType(int gtype, GeometryType geometryType) {
        this.gtype = gtype;
        this.matchingGeometryType = geometryType;
    }

    int intValue() {
        return this.gtype;
    }

    static SdoGeometryType parse(int v) {
        for (SdoGeometryType gt : SdoGeometryType.values()) {
            if (gt.intValue() != v) continue;
            return gt;
        }
        throw new RuntimeException("Value " + v + " isn't a valid TypeGeometry value");
    }

    static <P extends Position> SdoGeometryType forGeometry(Geometry<P> geom) {
        if (geom == null) {
            return null;
        }
        for (SdoGeometryType gt : SdoGeometryType.values()) {
            if (gt.matchingGeometryType == null || !gt.matchingGeometryType.equals((Object)geom.getGeometryType())) continue;
            return gt;
        }
        return null;
    }

    abstract AbstractSDODecoder createDecoder();

    public GeometryType getMatchingGeometryType() {
        return this.matchingGeometryType;
    }
}

