/*
 * Decompiled with CFR 0.152.
 */
package org.geomajas.dojo.server.json;

import com.metaparadigm.jsonrpc.AbstractSerializer;
import com.metaparadigm.jsonrpc.MarshallException;
import com.metaparadigm.jsonrpc.ObjectMatch;
import com.metaparadigm.jsonrpc.SerializerState;
import com.metaparadigm.jsonrpc.UnmarshallException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.geomajas.global.Json;
import org.geomajas.layer.feature.attribute.PrimitiveAttribute;
import org.geomajas.service.BeanNameSimplifier;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component(value="dojo.server.json.AnnotatedBeanSerializer")
public class AnnotatedBeanSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 1L;
    private final Logger log = LoggerFactory.getLogger(AnnotatedBeanSerializer.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private BeanNameSimplifier beanNameSimplifier;
    private static final Map<Class, BeanData> BEAN_CACHE = new ConcurrentHashMap<Class, BeanData>();
    private static final Class[] SERIALIZABLE_CLASSES = new Class[0];
    private static final Class[] JSON_CLASSES = new Class[0];

    public Class[] getSerializableClasses() {
        return SERIALIZABLE_CLASSES;
    }

    public Class[] getJSONClasses() {
        return JSON_CLASSES;
    }

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        return !clazz.isArray() && !clazz.isPrimitive() && (jsonClazz == null || jsonClazz == JSONObject.class);
    }

    private BeanData analyzeBean(Class clazz) throws IntrospectionException {
        PropertyDescriptor[] props;
        this.log.debug("analyzing {}", (Object)clazz.getName());
        BeanData bd = new BeanData();
        bd.beanInfo = Introspector.getBeanInfo(clazz, clazz.isEnum() ? Enum.class : Object.class);
        bd.readableProps = new HashMap();
        bd.writableProps = new HashMap();
        for (PropertyDescriptor prop : props = bd.beanInfo.getPropertyDescriptors()) {
            Json json;
            Method readMethod;
            Method writeMethod = prop.getWriteMethod();
            if (writeMethod != null) {
                Json json2 = writeMethod.getAnnotation(Json.class);
                if (json2 == null || json2.serialize()) {
                    bd.writableProps.put(prop.getName(), writeMethod);
                } else {
                    this.log.debug("skipping property {} for {}", (Object)prop.getName(), (Object)clazz.getName());
                }
            }
            if ((readMethod = prop.getReadMethod()) == null && writeMethod != null && writeMethod.getParameterTypes()[0].equals(Boolean.class) && writeMethod.getName().startsWith("set")) {
                String isMethodName = "is" + writeMethod.getName().substring(3);
                try {
                    readMethod = clazz.getMethod(isMethodName, new Class[0]);
                    if (!readMethod.getReturnType().equals(Boolean.class)) {
                        readMethod = null;
                    }
                }
                catch (Exception e) {
                    this.log.error("discarding:" + e.getMessage());
                }
            }
            if (readMethod == null || (json = readMethod.getAnnotation(Json.class)) != null && !json.serialize()) continue;
            bd.readableProps.put(prop.getName(), readMethod);
        }
        if (clazz.isEnum()) {
            try {
                bd.readableProps.put("value", clazz.getMethod("value", new Class[0]));
            }
            catch (Exception e) {
                try {
                    bd.readableProps.put("value", Enum.class.getMethod("name", new Class[0]));
                }
                catch (Exception e1) {
                    this.log.warn("cannot extract value of enum " + clazz.getName());
                }
            }
        }
        return bd;
    }

    private BeanData getBeanData(Class clazz) throws IntrospectionException {
        BeanData bd = BEAN_CACHE.get(clazz);
        if (bd == null) {
            bd = this.analyzeBean(clazz);
            BEAN_CACHE.put(clazz, bd);
        }
        return bd;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        BeanData bd;
        JSONObject jso = (JSONObject)o;
        try {
            bd = this.getBeanData(clazz);
        }
        catch (IntrospectionException e) {
            throw new UnmarshallException(clazz.getName() + " is not a bean");
        }
        int match = 0;
        int mismatch = 0;
        for (Map.Entry ent : bd.writableProps.entrySet()) {
            String prop = (String)ent.getKey();
            if (jso.has(prop)) {
                ++match;
                continue;
            }
            ++mismatch;
        }
        if (match == 0) {
            throw new UnmarshallException("bean has no matches");
        }
        ObjectMatch m = null;
        Iterator i = jso.keys();
        while (i.hasNext()) {
            String field = (String)i.next();
            Method setMethod = (Method)bd.writableProps.get(field);
            if (setMethod != null) {
                try {
                    Class<?>[] param = setMethod.getParameterTypes();
                    if (param.length != 1) {
                        throw new UnmarshallException("bean " + clazz.getName() + " method " + setMethod.getName() + " does not have one arg");
                    }
                    ObjectMatch tmp = this.ser.tryUnmarshall(state, param[0], jso.get(field));
                    if (m == null) {
                        m = tmp;
                        continue;
                    }
                    m = m.max(tmp);
                    continue;
                }
                catch (UnmarshallException e) {
                    throw new UnmarshallException("bean " + clazz.getName() + " " + e.getMessage());
                }
            }
            ++mismatch;
        }
        return m.max(new ObjectMatch(mismatch));
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        Object instance;
        BeanData bd;
        JSONObject jso = (JSONObject)o;
        try {
            bd = this.getBeanData(clazz);
        }
        catch (IntrospectionException e) {
            throw new UnmarshallException(clazz.getName() + " is not a bean");
        }
        this.log.debug("instantiating {}", (Object)clazz.getName());
        try {
            String beanName = this.beanNameSimplifier.simplify(clazz.getName());
            if (this.applicationContext.containsBean(beanName)) {
                instance = this.applicationContext.getBean(beanName);
            } else {
                this.log.debug("instantiating " + clazz.getName());
                instance = clazz.newInstance();
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnmarshallException("can't instantiate bean " + clazz.getName() + ": " + e.getMessage());
        }
        Object[] invokeArgs = new Object[1];
        Iterator i = jso.keys();
        while (i.hasNext()) {
            Object fieldVal;
            String field = (String)i.next();
            Method setMethod = (Method)bd.writableProps.get(field);
            if (setMethod == null) continue;
            try {
                Class<Object> param = setMethod.getParameterTypes()[0];
                if (instance instanceof PrimitiveAttribute && "value".equals(field)) {
                    this.log.debug("replace 'value' type for PrimitiveAttribute");
                    switch (((PrimitiveAttribute)instance).getType()) {
                        case BOOLEAN: {
                            param = Boolean.class;
                            break;
                        }
                        case DATE: {
                            param = Date.class;
                            break;
                        }
                        case DOUBLE: {
                            param = Double.class;
                            break;
                        }
                        case FLOAT: {
                            param = Float.class;
                            break;
                        }
                        case INTEGER: {
                            param = Integer.class;
                            break;
                        }
                        case LONG: {
                            param = Long.class;
                            break;
                        }
                        case SHORT: {
                            param = Short.class;
                            break;
                        }
                        case CURRENCY: 
                        case IMGURL: 
                        case URL: 
                        case STRING: {
                            param = String.class;
                            break;
                        }
                        default: {
                            throw new UnmarshallException("Unknown type of PrimitiveAttribute " + ((PrimitiveAttribute)instance).getType());
                        }
                    }
                }
                fieldVal = this.ser.unmarshall(state, param, jso.get(field));
            }
            catch (UnmarshallException e) {
                throw new UnmarshallException("bean " + clazz.getName() + " " + e.getMessage());
            }
            this.log.debug("invoking {}({})", (Object)setMethod.getName(), fieldVal);
            invokeArgs[0] = fieldVal;
            try {
                setMethod.invoke(instance, invokeArgs);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                throw new UnmarshallException("bean " + clazz.getName() + "can't invoke " + setMethod.getName() + ": " + e.getMessage());
            }
        }
        return instance;
    }

    public Object marshall(SerializerState state, Object o) throws MarshallException {
        BeanSerializerState beanState;
        try {
            beanState = (BeanSerializerState)state.get(BeanSerializerState.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MarshallException("bean serializer internal error : " + e.getMessage());
        }
        Integer identity = new Integer(System.identityHashCode(o));
        if (beanState.beanSet.contains(identity)) {
            throw new MarshallException("circular reference");
        }
        beanState.beanSet.add(identity);
        BeanData bd = null;
        try {
            bd = this.getBeanData(o.getClass());
        }
        catch (IntrospectionException e) {
            throw new MarshallException(o.getClass().getName() + " is not a bean");
        }
        JSONObject val = new JSONObject();
        if (this.ser.getMarshallClassHints()) {
            val.put("javaClass", (Object)o.getClass().getName());
        }
        Iterator i = bd.readableProps.entrySet().iterator();
        Object[] args = new Object[]{};
        while (i.hasNext()) {
            Object result;
            Map.Entry ent = i.next();
            String prop = (String)ent.getKey();
            Method getMethod = (Method)ent.getValue();
            this.log.debug("invoking {}()", (Object)getMethod.getName());
            try {
                result = getMethod.invoke(o, args);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getTargetException();
                }
                throw new MarshallException("bean " + o.getClass().getName() + " can't invoke " + getMethod.getName() + ": " + e.getMessage());
            }
            try {
                if (result == null && !this.ser.getMarshallNullAttributes()) continue;
                val.put(prop, this.ser.marshall(state, result));
            }
            catch (MarshallException e) {
                throw new MarshallException("bean " + o.getClass().getName() + " " + e.getMessage());
            }
        }
        beanState.beanSet.remove(identity);
        return val;
    }

    public static class BeanSerializerState {
        private HashSet beanSet = new HashSet();

        public HashSet getBeanSet() {
            return this.beanSet;
        }

        public void setBeanSet(HashSet beanSet) {
            this.beanSet = beanSet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeanData {
        private BeanInfo beanInfo;
        private HashMap<String, Method> readableProps;
        private HashMap<String, Method> writableProps;

        private BeanData() {
        }

        public BeanInfo getBeanInfo() {
            return this.beanInfo;
        }

        public void setBeanInfo(BeanInfo beanInfo) {
            this.beanInfo = beanInfo;
        }

        public HashMap<String, Method> getReadableProps() {
            return this.readableProps;
        }

        public void setReadableProps(HashMap<String, Method> readableProps) {
            this.readableProps = readableProps;
        }

        public HashMap<String, Method> getWritableProps() {
            return this.writableProps;
        }

        public void setWritableProps(HashMap<String, Method> writableProps) {
            this.writableProps = writableProps;
        }
    }
}

