/*
 * Decompiled with CFR 0.152.
 */
package org.geomajas.dojo.server.json;

import com.metaparadigm.jsonrpc.AbstractSerializer;
import com.metaparadigm.jsonrpc.MarshallException;
import com.metaparadigm.jsonrpc.ObjectMatch;
import com.metaparadigm.jsonrpc.SerializerState;
import com.metaparadigm.jsonrpc.UnmarshallException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.geomajas.dojo.server.json.GeometrySerializer;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigNumberSerializer
extends AbstractSerializer {
    private final Logger log = LoggerFactory.getLogger(GeometrySerializer.class);
    private static final long serialVersionUID = -1265127912351766084L;
    private static Class[] SERIALIZABLE_CLASSES = new Class[]{BigDecimal.class, BigInteger.class};
    private static Class[] JSON_CLASSES = new Class[]{JSONObject.class};

    public Class[] getSerializableClasses() {
        return SERIALIZABLE_CLASSES;
    }

    public Class[] getJSONClasses() {
        return JSON_CLASSES;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        try {
            this.toBigNumber(clazz, jso);
        }
        catch (NumberFormatException e) {
            throw new UnmarshallException("not a number");
        }
        return ObjectMatch.OKAY;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        try {
            if (jso == null || "".equals(jso)) {
                return null;
            }
            return this.toBigNumber(clazz, jso);
        }
        catch (NumberFormatException nfe) {
            throw new UnmarshallException("cannot convert object " + jso + " to type " + clazz.getName());
        }
    }

    public Object marshall(SerializerState state, Object o) throws MarshallException {
        this.log.debug("\nMarshalling object in the BigNumberSerializer\n");
        if (o instanceof BigInteger) {
            return ((BigInteger)o).longValue();
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).doubleValue();
        }
        return null;
    }

    private Object toBigNumber(Class clazz, Object jso) throws NumberFormatException {
        if (clazz == BigInteger.class) {
            if (jso instanceof String) {
                return new BigInteger((String)jso);
            }
            long l = ((Number)jso).longValue();
            return new BigInteger(new Long(l).toString());
        }
        if (clazz == BigDecimal.class) {
            if (jso instanceof String) {
                return new BigDecimal((String)jso);
            }
            double l = ((Number)jso).doubleValue();
            return new BigDecimal(new Double(l).toString());
        }
        return null;
    }
}

