/*
 * Decompiled with CFR 0.152.
 */
package org.geomajas.dojo.server.json;

import com.metaparadigm.jsonrpc.AbstractSerializer;
import com.metaparadigm.jsonrpc.MarshallException;
import com.metaparadigm.jsonrpc.ObjectMatch;
import com.metaparadigm.jsonrpc.SerializerState;
import com.metaparadigm.jsonrpc.UnmarshallException;

public class EnumSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 1L;
    private static Class[] SERIALIZABLE_CLASSES = new Class[]{Enum.class};
    private static Class[] JSON_CLASSES = new Class[]{String.class};

    public Class[] getSerializableClasses() {
        return SERIALIZABLE_CLASSES;
    }

    public Class[] getJSONClasses() {
        return JSON_CLASSES;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        try {
            this.toEnum(clazz, jso);
        }
        catch (IllegalArgumentException e) {
            throw new UnmarshallException("Not a valid enum string");
        }
        return ObjectMatch.OKAY;
    }

    public boolean canSerialize(Class clazz, Class jsonClazz) {
        boolean canJava = false;
        boolean canJSON = false;
        if (clazz.isEnum()) {
            canJava = true;
        }
        if (jsonClazz == null) {
            canJSON = true;
        } else {
            Class[] jsonClasses;
            for (Class jsonClass : jsonClasses = this.getJSONClasses()) {
                if (jsonClazz != jsonClass) continue;
                canJSON = true;
            }
        }
        return canJava && canJSON;
    }

    public Object toEnum(Class clazz, Object jso) throws IllegalArgumentException {
        return Enum.valueOf(clazz, (String)jso);
    }

    public Object unmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        try {
            if (jso == null || "".equals(jso)) {
                return null;
            }
            return this.toEnum(clazz, jso);
        }
        catch (IllegalArgumentException nfe) {
            throw new UnmarshallException("cannot convert object " + jso + " to type " + clazz.getName());
        }
    }

    public Object marshall(SerializerState state, Object o) throws MarshallException {
        return ((Enum)o).toString();
    }
}

