/*
 * Decompiled with CFR 0.152.
 */
package org.geomajas.dojo.server.json;

import com.metaparadigm.jsonrpc.AbstractSerializer;
import com.metaparadigm.jsonrpc.MarshallException;
import com.metaparadigm.jsonrpc.ObjectMatch;
import com.metaparadigm.jsonrpc.SerializerState;
import com.metaparadigm.jsonrpc.UnmarshallException;
import java.awt.Font;
import java.util.StringTokenizer;
import org.geomajas.dojo.server.json.GeometrySerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontSerializer
extends AbstractSerializer {
    private final Logger log = LoggerFactory.getLogger(GeometrySerializer.class);
    private static final long serialVersionUID = -1265127912351766084L;
    private static Class[] SERIALIZABLE_CLASSES = new Class[]{Font.class};
    private static Class[] JSON_CLASSES = new Class[]{String.class};

    public Class[] getSerializableClasses() {
        return SERIALIZABLE_CLASSES;
    }

    public Class[] getJSONClasses() {
        return JSON_CLASSES;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        try {
            this.unmarshal((String)jso);
        }
        catch (Exception e) {
            throw new UnmarshallException("cannot convert object " + jso + " to type " + clazz.getName());
        }
        return ObjectMatch.OKAY;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        try {
            return this.unmarshal((String)jso);
        }
        catch (Exception e) {
            this.log.error("cannot convert object " + jso + " to type " + clazz.getName(), (Throwable)e);
            throw new UnmarshallException("cannot convert object " + jso + " to type " + clazz.getName());
        }
    }

    public Object marshall(SerializerState state, Object o) throws MarshallException {
        if (o instanceof Font) {
            return this.marshal((Font)o);
        }
        return null;
    }

    private Font unmarshal(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        if (st.countTokens() < 2) {
            throw new IllegalArgumentException("Not enough tokens (<3) in font " + s);
        }
        int count = st.countTokens();
        String name = st.nextToken();
        int styleIndex = 0;
        if (count > 2) {
            String style = st.nextToken();
            if (style.equalsIgnoreCase("bold")) {
                styleIndex = 1;
            } else if (style.equalsIgnoreCase("italic")) {
                styleIndex = 2;
            }
        }
        int size = Integer.parseInt(st.nextToken());
        return new Font(name, styleIndex, size);
    }

    private String marshal(Font font) {
        String style = null;
        if (font.getStyle() == 1) {
            style = "bold";
        } else if (font.getStyle() == 2) {
            style = "italic";
        }
        return font.getName() + (style == null ? "" : "," + style) + "," + font.getSize();
    }
}

