/*
 * Decompiled with CFR 0.152.
 */
package org.geomajas.dojo.server.json;

import com.metaparadigm.jsonrpc.JSONRPCResult;
import java.io.CharArrayWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import org.geomajas.dojo.server.json.Writable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonObjectWriter
extends FilterWriter {
    private int charCount;
    private int logLines;
    private StringBuilder logBuffer = new StringBuilder();

    public JsonObjectWriter(Writer arg0, int logLines) {
        super(arg0);
        this.logLines = logLines;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.charCount < this.logLines * 1000) {
            if (this.charCount + len < this.logLines * 1000) {
                this.logBuffer.append(cbuf);
                this.charCount += len;
            } else {
                this.logBuffer.append(cbuf, 0, this.logLines * 1000 - this.charCount);
                this.charCount = this.logLines * 1000;
            }
        }
        super.write(cbuf, off, len);
    }

    public void write(int c) throws IOException {
        ++this.charCount;
        if (this.charCount < this.logLines * 1000) {
            this.logBuffer.append((char)c);
        }
        super.write(c);
    }

    public void write(String str, int off, int len) throws IOException {
        if (this.charCount < this.logLines * 1000) {
            if (this.charCount + len < this.logLines * 1000) {
                this.logBuffer.append(str);
                this.charCount += len;
            } else {
                this.logBuffer.append(str, 0, this.logLines * 1000 - this.charCount);
                this.charCount = this.logLines * 1000;
            }
        }
        super.write(str, off, len);
    }

    public void write(JSONObject object) throws IOException {
        Iterator keys = object.keys();
        Object o = null;
        this.write(123);
        while (keys.hasNext()) {
            String s;
            if (o != null) {
                this.write(44);
            }
            if ((o = object.get(s = (String)keys.next())) == null) continue;
            try {
                this.write(JSONObject.quote((String)s));
                this.write(58);
                this.writeObject(o);
            }
            catch (IOException ioe) {
                Logger log = LoggerFactory.getLogger(JsonObjectWriter.class);
                log.error("Problem writing " + s + " from " + object + " for value " + o + ", " + ioe.getMessage());
                throw ioe;
            }
            catch (ArithmeticException ae) {
                Logger log = LoggerFactory.getLogger(JsonObjectWriter.class);
                log.error("Problem writing " + s + ", " + ae.getMessage());
                throw ae;
            }
        }
        this.write(125);
    }

    public void write(JSONRPCResult result) throws IOException {
        JSONObject o = new JSONObject();
        if (result.getErrorCode() == 0) {
            o.put("id", result.getId());
            o.put("result", result.getResult());
        } else if (result.getErrorCode() == 490) {
            Throwable e = (Throwable)result.getResult();
            CharArrayWriter caw = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(caw));
            JSONObject err = new JSONObject();
            err.put("code", (Object)new Integer(result.getErrorCode()));
            err.put("msg", (Object)e.getMessage());
            err.put("trace", (Object)caw.toString());
            o.put("id", result.getId());
            o.put("error", (Object)err);
        } else {
            JSONObject err = new JSONObject();
            err.put("code", (Object)new Integer(result.getErrorCode()));
            err.put("msg", result.getResult());
            o.put("id", result.getId());
            o.put("error", (Object)err);
        }
        this.write(o);
    }

    private void writeObject(Object o) throws IOException {
        if (o instanceof String) {
            this.write(JSONObject.quote((String)((String)o)));
        } else if (o instanceof Number) {
            this.write(JSONObject.numberToString((Number)((Number)o)));
        } else if (o instanceof Writable) {
            ((Writable)o).write(this);
        } else if (o instanceof JSONArray) {
            JSONArray array = (JSONArray)o;
            this.write("[");
            for (int i = 0; i < array.length(); ++i) {
                if (i != 0) {
                    this.write(",");
                }
                this.writeObject(array.get(i));
            }
            this.write("]");
        } else if (o instanceof JSONObject) {
            this.write((JSONObject)o);
        } else {
            this.write(o.toString());
        }
    }
}

