/*
 * Decompiled with CFR 0.152.
 */
package org.geomajas.dojo.server.json;

import com.lowagie.text.Rectangle;
import com.metaparadigm.jsonrpc.AbstractSerializer;
import com.metaparadigm.jsonrpc.MarshallException;
import com.metaparadigm.jsonrpc.ObjectMatch;
import com.metaparadigm.jsonrpc.SerializerState;
import com.metaparadigm.jsonrpc.UnmarshallException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RectangleSerializer
extends AbstractSerializer {
    private final Logger log = LoggerFactory.getLogger(RectangleSerializer.class);
    private static final long serialVersionUID = -1265127912351766084L;
    private static Class[] SERIALIZABLE_CLASSES = new Class[]{Rectangle.class};
    private static Class[] JSON_CLASSES = new Class[]{JSONObject.class};

    public Class[] getSerializableClasses() {
        return SERIALIZABLE_CLASSES;
    }

    public Class[] getJSONClasses() {
        return JSON_CLASSES;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        JSONObject jso = (JSONObject)o;
        double x = jso.getDouble("x");
        double y = jso.getDouble("y");
        double width = jso.getDouble("width");
        double height = jso.getDouble("height");
        return ObjectMatch.OKAY;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object o) throws UnmarshallException {
        JSONObject jso = (JSONObject)o;
        String javaClass = jso.getString("javaClass");
        float x = (float)jso.getDouble("x");
        float y = (float)jso.getDouble("y");
        float width = (float)jso.getDouble("width");
        float height = (float)jso.getDouble("height");
        Rectangle rect = new Rectangle(x, y, x + width, y + height);
        return rect;
    }

    public Object marshall(SerializerState state, Object o) throws MarshallException {
        Rectangle rect = (Rectangle)o;
        JSONObject obj = new JSONObject();
        if (this.ser.getMarshallClassHints()) {
            obj.put("javaClass", (Object)o.getClass().getName());
        }
        obj.put("x", (double)rect.getLeft());
        obj.put("y", (double)rect.getBottom());
        obj.put("width", (double)rect.getWidth());
        obj.put("height", (double)rect.getHeight());
        return obj;
    }
}

