/*
 * Decompiled with CFR 0.152.
 */
package org.geomajas.dojo.server.servlet;

import com.metaparadigm.jsonrpc.ArraySerializer;
import com.metaparadigm.jsonrpc.BooleanSerializer;
import com.metaparadigm.jsonrpc.DateSerializer;
import com.metaparadigm.jsonrpc.DictionarySerializer;
import com.metaparadigm.jsonrpc.ErrorInvocationCallback;
import com.metaparadigm.jsonrpc.InvocationCallback;
import com.metaparadigm.jsonrpc.JSONRPCBridge;
import com.metaparadigm.jsonrpc.JSONRPCResult;
import com.metaparadigm.jsonrpc.ListSerializer;
import com.metaparadigm.jsonrpc.MapSerializer;
import com.metaparadigm.jsonrpc.NumberSerializer;
import com.metaparadigm.jsonrpc.PrimitiveSerializer;
import com.metaparadigm.jsonrpc.Serializer;
import com.metaparadigm.jsonrpc.SetSerializer;
import com.metaparadigm.jsonrpc.StringSerializer;
import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.text.ParseException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geomajas.command.CommandDispatcher;
import org.geomajas.dojo.server.json.AnnotatedBeanSerializer;
import org.geomajas.dojo.server.json.BigNumberSerializer;
import org.geomajas.dojo.server.json.ColorSerializer;
import org.geomajas.dojo.server.json.DtoGeometrySerializer;
import org.geomajas.dojo.server.json.FontSerializer;
import org.geomajas.dojo.server.json.GeometrySerializer;
import org.geomajas.dojo.server.json.JsonObjectWriter;
import org.geomajas.dojo.server.json.RectangleSerializer;
import org.geomajas.servlet.ApplicationContextUtil;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonServlet
extends HttpServlet
implements ErrorInvocationCallback,
ApplicationListener<ContextRefreshedEvent> {
    private static final int BUFFER_SIZE = 1024;
    private static final String JSON_RPC_BRIDGE_ATTRIBUTE = "JSONRPCBridge";
    private static final long serialVersionUID = -6972738675426509939L;
    private final Logger log = LoggerFactory.getLogger(JsonServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.log.info("JSON servlet init");
        this.log.debug("current working directory = {}", (Object)System.getProperty("user.dir"));
        ApplicationContext applicationContext = ApplicationContextUtil.getApplicationContext((ServletConfig)config);
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)applicationContext).addApplicationListener((ApplicationListener)this);
        }
        this.initBridge(config, applicationContext);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        try {
            this.initBridge(this.getServletConfig(), event.getApplicationContext());
        }
        catch (ServletException e) {
            this.log.error("Could not reinitialize JSON bridge", (Throwable)e);
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int ret;
        long startTime = System.currentTimeMillis();
        this.log.debug("Incoming JSON message");
        JSONRPCBridge jsonBridge = (JSONRPCBridge)this.getServletContext().getAttribute(JSON_RPC_BRIDGE_ATTRIBUTE);
        response.setContentType("text/plain;charset=utf-8");
        JSONObject jsonReq = null;
        JSONRPCResult jsonRes = null;
        String charset = request.getCharacterEncoding();
        if (charset == null) {
            charset = "UTF-8";
        }
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream(), charset));
        CharArrayWriter data = new CharArrayWriter();
        char[] buf = new char[1024];
        while ((ret = in.read(buf, 0, 1024)) != -1) {
            data.write(buf, 0, ret);
        }
        this.writeReceive(data.toString());
        try {
            jsonReq = new JSONObject(data.toString());
            jsonRes = jsonBridge.call(new Object[]{request}, jsonReq);
        }
        catch (ParseException e) {
            this.log.error("can't parse call: " + data, (Throwable)e);
            jsonRes = new JSONRPCResult(590, null, (Object)"couldn't parse request arguments");
        }
        JsonObjectWriter writer = new JsonObjectWriter(response.getWriter(), 3);
        writer.write(jsonRes);
        writer.flush();
        JSONArray jsonArray = (JSONArray)jsonReq.get("params");
        long millis = System.currentTimeMillis() - startTime;
        this.log.debug("Command execution time: " + millis + " ms - class=" + jsonArray.toString());
    }

    private void writeReceive(String receive) {
        if (this.log.isDebugEnabled()) {
            String str = receive.toString();
            int index = 0;
            while (index + 999 < str.length()) {
                this.log.debug("service: receive [" + index + "] " + str.substring(index, index + 999));
                index += 1000;
            }
            this.log.debug("service: receive " + str.substring(index));
        }
    }

    public void postInvoke(Object context, Object instance, Method method, Object result) throws Exception {
    }

    public void preInvoke(Object context, Object instance, Method method, Object[] arguments) throws Exception {
    }

    public void invocationError(Object context, Object instance, Method method, Throwable error) {
        this.log.error("JSON invocation error", error);
    }

    private void initBridge(ServletConfig config, ApplicationContext applicationContext) throws ServletException {
        JSONRPCBridge jsonBridge = new JSONRPCBridge(false);
        try {
            jsonBridge.registerSerializer((Serializer)applicationContext.getBean("dojo.server.json.AnnotatedBeanSerializer", AnnotatedBeanSerializer.class));
            jsonBridge.registerSerializer((Serializer)new GeometrySerializer());
            jsonBridge.registerSerializer((Serializer)new DtoGeometrySerializer());
            jsonBridge.registerSerializer((Serializer)new BigNumberSerializer());
            jsonBridge.registerSerializer((Serializer)new ArraySerializer());
            jsonBridge.registerSerializer((Serializer)new DictionarySerializer());
            jsonBridge.registerSerializer((Serializer)new MapSerializer());
            jsonBridge.registerSerializer((Serializer)new SetSerializer());
            jsonBridge.registerSerializer((Serializer)new ListSerializer());
            jsonBridge.registerSerializer((Serializer)new DateSerializer());
            jsonBridge.registerSerializer((Serializer)new StringSerializer());
            jsonBridge.registerSerializer((Serializer)new NumberSerializer());
            jsonBridge.registerSerializer((Serializer)new BooleanSerializer());
            jsonBridge.registerSerializer((Serializer)new PrimitiveSerializer());
            jsonBridge.registerSerializer((Serializer)new RectangleSerializer());
            jsonBridge.registerSerializer((Serializer)new ColorSerializer());
            jsonBridge.registerSerializer((Serializer)new FontSerializer());
        }
        catch (Exception e) {
            throw new ServletException("json : could not register all serializers", (Throwable)e);
        }
        CommandDispatcher commandDispatcher = (CommandDispatcher)applicationContext.getBean("command.CommandDispatcher", CommandDispatcher.class);
        if (null == commandDispatcher) {
            throw new ServletException("Cannot find CommandDispatcher, the org.geomajas.internal.global.GeomajasContextListener was probably not registered.");
        }
        jsonBridge.registerObject((Object)"CommandDispatcher", (Object)commandDispatcher);
        jsonBridge.registerCallback((InvocationCallback)this, HttpServletRequest.class);
        config.getServletContext().setAttribute(JSON_RPC_BRIDGE_ATTRIBUTE, (Object)jsonBridge);
    }
}

