/*
 * Decompiled with CFR 0.152.
 */
package org.geomesa.testcontainers;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.ClientProperty;
import org.geomesa.testcontainers.UnoContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class AccumuloContainer
extends UnoContainer<AccumuloContainer> {
    private static final Logger logger = LoggerFactory.getLogger(AccumuloContainer.class);
    private final String instanceName = "uno";
    private final String username = "root";
    private final String password = "secret";
    private final int zookeeperPort = AccumuloContainer.getFreePort();
    private static final String DISTRIBUTED_RUNTIME_PROPS = "geomesa-accumulo-distributed-runtime.properties";

    public AccumuloContainer() {
        this(DEFAULT_IMAGE);
    }

    public AccumuloContainer(DockerImageName imageName) {
        super(imageName);
        int tserverPort = AccumuloContainer.getFreePort();
        int managerPort = AccumuloContainer.getFreePort();
        this.addFixedExposedPort(this.zookeeperPort, this.zookeeperPort);
        this.addFixedExposedPort(tserverPort, tserverPort);
        this.addFixedExposedPort(managerPort, managerPort);
        this.addExposedPorts(new int[]{9995});
        this.addEnv("ZOOKEEPER_PORT", Integer.toString(this.zookeeperPort));
        this.addEnv("TSERVER_PORT", Integer.toString(tserverPort));
        this.addEnv("MANAGER_PORT", Integer.toString(managerPort));
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Running accumulo complete.*", (int)1));
        this.withLogConsumer((Consumer)((Object)new AccumuloLogConsumer()));
    }

    public AccumuloContainer withGeoMesaDistributedRuntime() {
        return this.withGeoMesaDistributedRuntime(AccumuloContainer.findDistributedRuntime());
    }

    public AccumuloContainer withGeoMesaDistributedRuntime(String jarHostPath) {
        logger.info("Binding to host path {}", (Object)jarHostPath);
        return (AccumuloContainer)this.withFileSystemBind(jarHostPath, "/opt/fluo-uno/install/accumulo/lib/geomesa-accumulo-distributed-runtime.jar", BindMode.READ_ONLY);
    }

    public AccumuloClient client() {
        return this.client("root", "secret");
    }

    public AccumuloClient client(String username, String password) {
        return this.client(username, (AuthenticationToken)new PasswordToken(password.getBytes(StandardCharsets.UTF_8)));
    }

    public AccumuloClient client(String username, AuthenticationToken password) {
        Properties props = new Properties();
        props.setProperty(ClientProperty.INSTANCE_NAME.getKey(), "uno");
        props.setProperty(ClientProperty.INSTANCE_ZOOKEEPERS.getKey(), this.getZookeepers());
        return (AccumuloClient)Accumulo.newClient().from(props).as((CharSequence)username, password).build();
    }

    public String getInstanceName() {
        return "uno";
    }

    public String getUsername() {
        return "root";
    }

    public String getPassword() {
        return "secret";
    }

    public String getZookeepers() {
        return this.getHost() + ":" + this.zookeeperPort;
    }

    private static int getFreePort() {
        int n;
        ServerSocket socket = new ServerSocket(0);
        try {
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to get free port", e);
            }
        }
        socket.close();
        return n;
    }

    private static String findDistributedRuntime() {
        String path = null;
        try {
            URL url = AccumuloContainer.class.getClassLoader().getResource(DISTRIBUTED_RUNTIME_PROPS);
            URI uri = url == null ? null : url.toURI();
            logger.debug("Distributed runtime lookup: {}", (Object)uri);
            if (uri != null && uri.toString().endsWith("/target/classes/geomesa-accumulo-distributed-runtime.properties")) {
                File targetDir = Paths.get(uri).toFile().getParentFile().getParentFile();
                File[] names = targetDir.listFiles((dir, name) -> name.startsWith("geomesa-accumulo-distributed-runtime_") && (name.endsWith("-SNAPSHOT.jar") || name.matches(".*-[0-9]+\\.[0-9]+\\.[0-9]+\\.jar")));
                if (names != null && names.length == 1) {
                    path = names[0].getAbsolutePath();
                }
            } else if (uri != null && "jar".equals(uri.getScheme())) {
                String jar = uri.toString().substring(4).replaceAll("\\.jar!.*", ".jar");
                path = Paths.get(URI.create(jar)).toFile().getAbsolutePath();
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not load geomesa-accumulo-distributed-runtime JAR from classpath", e);
        }
        if (path == null) {
            throw new RuntimeException("Could not load geomesa-accumulo-distributed-runtime JAR from classpath");
        }
        return path;
    }

    private static class AccumuloLogConsumer
    extends Slf4jLogConsumer {
        private boolean output = true;

        public AccumuloLogConsumer() {
            super(LoggerFactory.getLogger((String)"accumulo"), true);
        }

        public void accept(OutputFrame outputFrame) {
            if (this.output) {
                super.accept(outputFrame);
                if (outputFrame.getUtf8StringWithoutLineEnding().matches(".*Running accumulo complete.*")) {
                    this.output = false;
                    byte[] msg = "Container started - suppressing further output".getBytes(StandardCharsets.UTF_8);
                    super.accept(new OutputFrame(OutputFrame.OutputType.STDOUT, msg));
                }
            }
        }
    }
}

