/*
 * Decompiled with CFR 0.152.
 */
package org.geomesa.testcontainers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.geomesa.testcontainers.UnoContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class HadoopContainer
extends UnoContainer<HadoopContainer> {
    private static final Logger logger = LoggerFactory.getLogger(HadoopContainer.class);
    private final int namenodePort = HadoopContainer.getFreePort();
    private final int datanodePort = HadoopContainer.getFreePort();
    private final int datanodeIpcPort = HadoopContainer.getFreePort();
    private final int journalnodeRpcPort = HadoopContainer.getFreePort();
    private final int resourceManagerSchedulerPort = HadoopContainer.getFreePort();
    private final int resourceManagerTrackerPort = HadoopContainer.getFreePort();
    private final int resourceManagerPort = HadoopContainer.getFreePort();
    private final int jobHistoryPort = HadoopContainer.getFreePort();

    public HadoopContainer() {
        this(DEFAULT_IMAGE);
    }

    public HadoopContainer(DockerImageName imageName) {
        super(imageName);
        this.addEnv("UNO_SERVICE", "hadoop");
        this.addEnv("NAMENODE_PORT", Integer.toString(this.namenodePort));
        this.addEnv("DATANODE_PORT", Integer.toString(this.datanodePort));
        this.addEnv("DATANODE_IPC_PORT", Integer.toString(this.datanodeIpcPort));
        this.addEnv("JOURNALNODE_RPC_PORT", Integer.toString(this.journalnodeRpcPort));
        this.addEnv("YARN_RESOURCEMANAGER_SCHEDULER_PORT", Integer.toString(this.resourceManagerSchedulerPort));
        this.addEnv("YARN_RESOURCEMANAGER_TRACKER_PORT", Integer.toString(this.resourceManagerTrackerPort));
        this.addEnv("YARN_RESOURCEMANAGER_PORT", Integer.toString(this.resourceManagerPort));
        this.addEnv("MAPRED_JOBHISTORY_PORT", Integer.toString(this.jobHistoryPort));
        this.addFixedExposedPort(this.namenodePort, this.namenodePort);
        this.addFixedExposedPort(this.datanodePort, this.datanodePort);
        this.addFixedExposedPort(this.datanodeIpcPort, this.datanodeIpcPort);
        this.addFixedExposedPort(this.journalnodeRpcPort, this.journalnodeRpcPort);
        this.addFixedExposedPort(this.resourceManagerSchedulerPort, this.resourceManagerSchedulerPort);
        this.addFixedExposedPort(this.resourceManagerTrackerPort, this.resourceManagerTrackerPort);
        this.addFixedExposedPort(this.resourceManagerPort, this.resourceManagerPort);
        this.addFixedExposedPort(this.jobHistoryPort, this.jobHistoryPort);
        this.addExposedPorts(new int[]{8088, 9870});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Running hadoop complete.*", (int)1));
        this.withLogConsumer((Consumer)((Object)new HadoopLogConsumer()));
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        super.containerIsStarted(containerInfo);
        logger.info("The NameNode UI is available locally at: " + this.getHost() + ":" + this.getMappedPort(9870) + "/");
        logger.info("The ResourceManager UI is available locally at: " + this.getHost() + ":" + this.getMappedPort(8088) + "/");
    }

    public String getHdfsUrl() {
        return "hdfs://" + this.getHost() + ":" + this.namenodePort;
    }

    public String getConfigurationXml() {
        return "<configuration>\n  <property>\n    <name>fs.defaultFS</name>\n    <value>" + this.getHdfsUrl() + "</value>\n  </property>\n  <property>\n    <name>dfs.namenode.rpc-address</name>\n    <value>" + this.getHost() + ":" + this.namenodePort + "</value>\n  </property>\n  <property>\n    <name>dfs.datanode.address</name>\n    <value>" + this.getHost() + ":" + this.datanodePort + "</value>\n  </property>\n  <property>\n    <name>dfs.datanode.ipc.address</name>\n    <value>" + this.getHost() + ":" + this.datanodeIpcPort + "</value>\n  </property>\n  <property>\n    <name>dfs.journalnode.rpc-address</name>\n    <value>" + this.getHost() + ":" + this.journalnodeRpcPort + "</value>\n  </property>\n  <property>\n    <name>yarn.resourcemanager.scheduler.address</name>\n    <value>" + this.getHost() + ":" + this.resourceManagerSchedulerPort + "</value>\n  </property>\n  <property>\n    <name>yarn.resourcemanager.resource-tracker.address</name>\n    <value>" + this.getHost() + ":" + this.resourceManagerTrackerPort + "</value>\n  </property>\n  <property>\n    <name>yarn.resourcemanager.address</name>\n    <value>" + this.getHost() + ":" + this.resourceManagerPort + "</value>\n  </property>\n  <property>\n    <name>mapreduce.jobhistory.address</name>\n    <value>" + this.getHost() + ":" + this.jobHistoryPort + "</value>\n  </property>\n  <property>\n    <name>dfs.client.use.datanode.hostname</name>\n    <value>true</value>\n  </property>\n</configuration>";
    }

    private static int getFreePort() {
        int n;
        ServerSocket socket = new ServerSocket(0);
        try {
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to get free port", e);
            }
        }
        socket.close();
        return n;
    }

    private static class HadoopLogConsumer
    extends Slf4jLogConsumer {
        private boolean output = true;

        public HadoopLogConsumer() {
            super(LoggerFactory.getLogger((String)"hadoop"), true);
        }

        public void accept(OutputFrame outputFrame) {
            if (this.output) {
                super.accept(outputFrame);
                if (outputFrame.getUtf8StringWithoutLineEnding().matches(".*Running hadoop complete.*")) {
                    this.output = false;
                    byte[] msg = "Container started - suppressing further output".getBytes(StandardCharsets.UTF_8);
                    super.accept(new OutputFrame(OutputFrame.OutputType.STDOUT, msg));
                }
            }
        }
    }
}

