/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.module.georss;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.georss.GMLParser;
import com.sun.syndication.feed.module.georss.GeoRSSModule;
import com.sun.syndication.feed.module.georss.GeoRSSUtils;
import com.sun.syndication.feed.module.georss.SimpleModuleImpl;
import com.sun.syndication.feed.module.georss.geometries.Envelope;
import com.sun.syndication.feed.module.georss.geometries.LineString;
import com.sun.syndication.feed.module.georss.geometries.LinearRing;
import com.sun.syndication.feed.module.georss.geometries.Point;
import com.sun.syndication.feed.module.georss.geometries.Polygon;
import com.sun.syndication.feed.module.georss.geometries.Position;
import com.sun.syndication.feed.module.georss.geometries.PositionList;
import com.sun.syndication.io.ModuleParser;
import org.jdom.Element;

public class SimpleParser
implements ModuleParser {
    public String getNamespaceUri() {
        return "http://www.georss.org/georss";
    }

    private static PositionList parsePosList(Element element) {
        String string = element.getText();
        String[] stringArray = GeoRSSUtils.trimWhitespace(string).split(" ");
        PositionList positionList = new PositionList();
        for (int i = 0; i < stringArray.length; i += 2) {
            positionList.add(Double.parseDouble(stringArray[i]), Double.parseDouble(stringArray[i + 1]));
        }
        return positionList;
    }

    public Module parse(Element element) {
        Module module = SimpleParser.parseSimple(element);
        return module;
    }

    static Module parseSimple(Element element) {
        GeoRSSModule geoRSSModule = null;
        Element element2 = element.getChild("point", GeoRSSModule.SIMPLE_NS);
        Element element3 = element.getChild("line", GeoRSSModule.SIMPLE_NS);
        Element element4 = element.getChild("polygon", GeoRSSModule.SIMPLE_NS);
        Element element5 = element.getChild("box", GeoRSSModule.SIMPLE_NS);
        Element element6 = element.getChild("where", GeoRSSModule.SIMPLE_NS);
        if (element2 != null) {
            geoRSSModule = new SimpleModuleImpl();
            String string = element2.getText();
            String[] stringArray = GeoRSSUtils.trimWhitespace(string).split(" ");
            Position position = new Position(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]));
            geoRSSModule.setGeometry(new Point(position));
        } else if (element3 != null) {
            geoRSSModule = new SimpleModuleImpl();
            PositionList positionList = SimpleParser.parsePosList(element3);
            geoRSSModule.setGeometry(new LineString(positionList));
        } else if (element4 != null) {
            geoRSSModule = new SimpleModuleImpl();
            PositionList positionList = SimpleParser.parsePosList(element4);
            Polygon polygon = new Polygon();
            polygon.setExterior(new LinearRing(positionList));
            geoRSSModule.setGeometry(polygon);
        } else if (element5 != null) {
            geoRSSModule = new SimpleModuleImpl();
            String string = element5.getText();
            String[] stringArray = GeoRSSUtils.trimWhitespace(string).split(" ");
            Envelope envelope = new Envelope(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[3]));
            geoRSSModule.setGeometry(envelope);
        } else if (element6 != null) {
            geoRSSModule = (GeoRSSModule)GMLParser.parseGML(element6);
        }
        return geoRSSModule;
    }
}

