/**
 * <copyright>
 * </copyright>
 *
 * $Id: GetLogType.java 7988 2007-12-12 20:29:15Z aaime $
 */
package net.opengis.wfsv;

import java.math.BigInteger;

import net.opengis.wfs.BaseRequestType;
import net.opengis.wfs.ResultTypeType;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Get Log Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * 
 *         A GetLog element contains one or more DifferenceQuery elements that describe a diffence
 *         query operation on one feature type. In response to a GetLog request, a Web Feature Service
 *         must be able to generate a list of logs entries for features matched by the DifferenceQuery
 *         parameters. Each log entry is an instance of the ChangeSet feature type. In response to a
 *         GetFeature request, a Versioning Web Feature Service must be able to generate a GML3
 *         response that validates using a schema generated by the DescribeFeatureType request against
 *         the ChangeSets feature type. A Web Feature Service may support other possibly non-XML (and
 *         even binary) output formats as long as those formats are advertised in the capabilities
 *         document.
 *       
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link net.opengis.wfsv.GetLogType#getDifferenceQuery <em>Difference Query</em>}</li>
 *   <li>{@link net.opengis.wfsv.GetLogType#getMaxFeatures <em>Max Features</em>}</li>
 *   <li>{@link net.opengis.wfsv.GetLogType#getOutputFormat <em>Output Format</em>}</li>
 *   <li>{@link net.opengis.wfsv.GetLogType#getResultType <em>Result Type</em>}</li>
 * </ul>
 * </p>
 *
 * @see net.opengis.wfsv.WfsvPackage#getGetLogType()
 * @model extendedMetaData="name='GetLogType' kind='elementOnly'"
 * @generated
 */
public interface GetLogType extends BaseRequestType {
    /**
     * Returns the value of the '<em><b>Difference Query</b></em>' containment reference list.
     * The list contents are of type {@link net.opengis.wfsv.DifferenceQueryType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * <!-- begin-model-doc -->
     * 
     *         The DifferenceFilter element is used to gather differences in features matched by a standard
     *         OGC filter at starting and ending featureVersion, and a filter used to match
     *       
     * <!-- end-model-doc -->
     * @return the value of the '<em>Difference Query</em>' containment reference list.
     * @see net.opengis.wfsv.WfsvPackage#getGetLogType_DifferenceQuery()
     * @model type="net.opengis.wfsv.DifferenceQueryType" containment="true" required="true"
     *        extendedMetaData="kind='element' name='DifferenceQuery' namespace='##targetNamespace'"
     * @generated
     */
    EList getDifferenceQuery();

    /**
     * Returns the value of the '<em><b>Max Features</b></em>' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * <!-- begin-model-doc -->
     * 
     *               The maxFeatures attribute is used to specify the maximum number of features that a
     *               GetFeature operation should generate (regardless of the actual number of query hits).
     *             
     * <!-- end-model-doc -->
     * @return the value of the '<em>Max Features</em>' attribute.
     * @see #setMaxFeatures(BigInteger)
     * @see net.opengis.wfsv.WfsvPackage#getGetLogType_MaxFeatures()
     * @model dataType="org.eclipse.emf.ecore.xml.type.PositiveInteger"
     *        extendedMetaData="kind='attribute' name='maxFeatures'"
     * @generated
     */
    BigInteger getMaxFeatures();

    /**
     * Sets the value of the '{@link net.opengis.wfsv.GetLogType#getMaxFeatures <em>Max Features</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Max Features</em>' attribute.
     * @see #getMaxFeatures()
     * @generated
     */
    void setMaxFeatures(BigInteger value);

    /**
     * Returns the value of the '<em><b>Output Format</b></em>' attribute.
     * The default value is <code>"text/xml; subtype=gml/3.1.1"</code>.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * <!-- begin-model-doc -->
     * 
     *               The outputFormat attribute is used to specify the output format that the Versioning
     *               Web Feature Service should generate in response to a GetLog element. The default value
     *               of 'text/xml; subtype=gml/3.1.1' indicates that the output is an XML document that
     *               conforms to the Geography Markup Language (GML) Implementation Specification V3.1.1.
     *               For the purposes of experimentation, vendor extension, or even extensions that serve a
     *               specific community of interest, other acceptable output format values may be used to
     *               specify other formats as long as those values are advertised in the capabilities
     *               document.
     *             
     * <!-- end-model-doc -->
     * @return the value of the '<em>Output Format</em>' attribute.
     * @see #isSetOutputFormat()
     * @see #unsetOutputFormat()
     * @see #setOutputFormat(String)
     * @see net.opengis.wfsv.WfsvPackage#getGetLogType_OutputFormat()
     * @model default="text/xml; subtype=gml/3.1.1" unsettable="true" dataType="org.eclipse.emf.ecore.xml.type.String"
     *        extendedMetaData="kind='attribute' name='outputFormat'"
     * @generated
     */
    String getOutputFormat();

    /**
     * Sets the value of the '{@link net.opengis.wfsv.GetLogType#getOutputFormat <em>Output Format</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Output Format</em>' attribute.
     * @see #isSetOutputFormat()
     * @see #unsetOutputFormat()
     * @see #getOutputFormat()
     * @generated
     */
    void setOutputFormat(String value);

    /**
     * Unsets the value of the '{@link net.opengis.wfsv.GetLogType#getOutputFormat <em>Output Format</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #isSetOutputFormat()
     * @see #getOutputFormat()
     * @see #setOutputFormat(String)
     * @generated
     */
    void unsetOutputFormat();

    /**
     * Returns whether the value of the '{@link net.opengis.wfsv.GetLogType#getOutputFormat <em>Output Format</em>}' attribute is set.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return whether the value of the '<em>Output Format</em>' attribute is set.
     * @see #unsetOutputFormat()
     * @see #getOutputFormat()
     * @see #setOutputFormat(String)
     * @generated
     */
    boolean isSetOutputFormat();

    /**
     * Returns the value of the '<em><b>Result Type</b></em>' attribute.
     * The default value is <code>"results"</code>.
     * The literals are from the enumeration {@link net.opengis.wfs.ResultTypeType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * <!-- begin-model-doc -->
     * 
     *               The resultType attribute is used to indicate what response a wfsv should return to
     *               user once a GetFeature request is processed. Possible values are: results - meaning
     *               that the full response set (i.e. all the feature instances) should be returned. hits -
     *               meaning that an empty response set should be returned (i.e. no feature instances
     *               should be returned) but the "numberOfFeatures" attribute should be set to the number
     *               of feature instances that would be returned.
     *             
     * <!-- end-model-doc -->
     * @return the value of the '<em>Result Type</em>' attribute.
     * @see net.opengis.wfs.ResultTypeType
     * @see #isSetResultType()
     * @see #unsetResultType()
     * @see #setResultType(ResultTypeType)
     * @see net.opengis.wfsv.WfsvPackage#getGetLogType_ResultType()
     * @model default="results" unsettable="true"
     *        extendedMetaData="kind='attribute' name='resultType'"
     * @generated
     */
    ResultTypeType getResultType();

    /**
     * Sets the value of the '{@link net.opengis.wfsv.GetLogType#getResultType <em>Result Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param value the new value of the '<em>Result Type</em>' attribute.
     * @see net.opengis.wfs.ResultTypeType
     * @see #isSetResultType()
     * @see #unsetResultType()
     * @see #getResultType()
     * @generated
     */
    void setResultType(ResultTypeType value);

    /**
     * Unsets the value of the '{@link net.opengis.wfsv.GetLogType#getResultType <em>Result Type</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #isSetResultType()
     * @see #getResultType()
     * @see #setResultType(ResultTypeType)
     * @generated
     */
    void unsetResultType();

    /**
     * Returns whether the value of the '{@link net.opengis.wfsv.GetLogType#getResultType <em>Result Type</em>}' attribute is set.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @return whether the value of the '<em>Result Type</em>' attribute is set.
     * @see #unsetResultType()
     * @see #getResultType()
     * @see #setResultType(ResultTypeType)
     * @generated
     */
    boolean isSetResultType();

} // GetLogType
