/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.geoserver.config.GeoServerLoader;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.wfs.WFS;
import org.geotools.validation.xml.XMLReader;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.config.validation.ValidationConfig;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.global.UserContainer;

public class LoadXMLAction
extends ConfigAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ActionForward r1 = this.loadValidation(mapping, form, request, response);
        ActionForward r2 = this.loadGeoserver(mapping, form, request, response);
        this.getApplicationState().fireChange();
        return mapping.findForward("config");
    }

    private ActionForward loadGeoserver(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        GeoServerLoader loader = (GeoServerLoader)GeoServerExtensions.bean(GeoServerLoader.class);
        try {
            loader.reload();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        GeoServer gs = this.getGeoServer();
        gs.init();
        this.getGlobalConfig().update(gs.toDTO());
        Data data = this.getData();
        this.getDataConfig().update(data.toDTO());
        this.getWCS(request).init();
        this.getWCSConfig().update(this.getWCS(request).toDTO());
        this.getWFS(request).init();
        this.getWFSConfig().update(this.getWFS(request).toDTO());
        this.getWMS(request).init();
        this.getWMSConfig().update(this.getWMS(request).toDTO());
        this.getApplicationState(request).notifyLoadXML();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(new StringBuffer("request: ").append(request.getServletPath()).toString());
            LOGGER.finer(new StringBuffer("forward: ").append(mapping.getForward()).toString());
        }
        return mapping.findForward("config");
    }

    private ActionForward loadValidation(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ServletContext sc = request.getSession().getServletContext();
        WFS wfs = this.getWFS(request);
        if (wfs == null) {
            this.loadGeoserver(mapping, form, request, response);
        }
        File rootDir = GeoserverDataDirectory.getGeoserverDataDirectory();
        try {
            File plugInDir = this.findConfigDir(rootDir, "plugIns");
            File validationDir = this.findConfigDir(rootDir, "validation");
            Map plugIns = XMLReader.loadPlugIns((File)plugInDir);
            Map testSuites = XMLReader.loadValidations((File)validationDir, (Map)plugIns);
            ValidationConfig vc = new ValidationConfig(plugIns, testSuites);
            sc.setAttribute("Validation.Config", (Object)vc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return mapping.findForward("config.validation");
        }
        return mapping.findForward("config.validation");
    }

    private File findConfigDir(File rootDir, String name) throws Exception {
        return GeoserverDataDirectory.findConfigDir((File)rootDir, (String)name);
    }
}

