/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action;

import com.vividsolutions.jts.geom.Envelope;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.util.MessageResources;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.action.GeoServerAction;
import org.vfny.geoserver.action.MapPreviewAction;
import org.vfny.geoserver.global.CoverageInfo;
import org.vfny.geoserver.global.Data;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.GeoServer;
import org.vfny.geoserver.global.Service;
import org.vfny.geoserver.global.WMS;
import org.vfny.geoserver.util.requests.CapabilitiesRequest;

public class MapPreviewAction
extends GeoServerAction {
    public static final Integer LAYER_IS_COVERAGE = new Integer(0);
    public static final Integer LAYER_HAS_COVERAGE = new Integer(1);
    public static final Integer LAYER_IS_VECTOR = new Integer(2);

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ReferencedEnvelope bbox;
        String msg;
        ArrayList<String> dsList = new ArrayList<String>();
        ArrayList<String> ftList = new ArrayList<String>();
        ArrayList<String> bboxList = new ArrayList<String>();
        ArrayList<String> srsList = new ArrayList<String>();
        ArrayList<String> ftnsList = new ArrayList<String>();
        ArrayList<String> widthList = new ArrayList<String>();
        ArrayList<String> heightList = new ArrayList<String>();
        ArrayList<Integer> coverageStatus = new ArrayList<Integer>();
        WMS wms = this.getWMS(request);
        CapabilitiesRequest capRequest = new CapabilitiesRequest("WMS", (Service)wms);
        capRequest.setHttpServletRequest(request);
        Data catalog = wms.getData();
        ArrayList ftypes = new ArrayList(catalog.getFeatureTypeInfos().values());
        Iterator it = ftypes.iterator();
        while (it.hasNext()) {
            FeatureTypeInfo ft = (FeatureTypeInfo)it.next();
            if (ft.isEnabled()) continue;
            it.remove();
        }
        Collections.sort(ftypes, new FeatureTypeInfoNameComparator(null));
        ArrayList ctypes = new ArrayList(catalog.getCoverageInfos().values());
        Iterator it2 = ctypes.iterator();
        while (it2.hasNext()) {
            CoverageInfo ci = (CoverageInfo)it2.next();
            if (ci.isEnabled()) continue;
            it2.remove();
        }
        Collections.sort(ctypes, new CoverageInfoNameComparator(null));
        ArrayList bmtypes = new ArrayList(wms.getBaseMapLayers().keySet());
        Collections.sort(bmtypes);
        ServletContext sc = request.getSession().getServletContext();
        if (sc.getRealPath("preview") == null) {
            throw new RuntimeException("Couldn't populate preview directory...is the war running in unpacked mode?");
        }
        File previewDir = new File(sc.getRealPath("preview"));
        if (!previewDir.exists()) {
            previewDir.mkdirs();
        }
        CoordinateReferenceSystem latLonCrs = null;
        try {
            latLonCrs = CRS.decode((String)"EPSG:4326");
        }
        catch (NoSuchAuthorityCodeException e) {
            msg = "Error looking up SRS for EPSG: 4326:" + e.getLocalizedMessage();
            LOGGER.warning(msg);
        }
        catch (FactoryException e) {
            msg = "Error looking up SRS for EPSG: 4326:" + e.getLocalizedMessage();
            LOGGER.warning(msg);
        }
        for (FeatureTypeInfo layer : ftypes) {
            try {
                if (!layer.isEnabled() || layer.isGeometryless()) continue;
                CoordinateReferenceSystem layerCrs = layer.getDeclaredCRS();
                Envelope orig_bbox = layer.getLatLongBoundingBox();
                if (orig_bbox.getWidth() == 0.0 || orig_bbox.getHeight() == 0.0) {
                    orig_bbox.expandBy(0.1);
                }
                bbox = new ReferencedEnvelope(orig_bbox, latLonCrs);
                if (!CRS.equalsIgnoreMetadata((Object)layerCrs, (Object)latLonCrs)) {
                    bbox = layer.getBoundingBox();
                }
                if (bbox.getWidth() == 0.0 || bbox.getHeight() == 0.0) {
                    bbox.expandBy(0.1);
                }
                if (!layer.isEnabled()) continue;
                ftList.add(layer.getNameSpace().getPrefix() + "_" + layer.getFeatureType().getTypeName());
                ftnsList.add(layer.getNameSpace().getPrefix() + ":" + layer.getFeatureType().getTypeName());
                dsList.add(layer.getDataStoreInfo().getId());
                bbox.expandBy(bbox.getWidth() / 20.0, bbox.getHeight() / 20.0);
                bboxList.add(bbox.getMinX() + "," + bbox.getMinY() + "," + bbox.getMaxX() + "," + bbox.getMaxY());
                srsList.add("EPSG:" + layer.getSRS());
                int[] imageBox = this.getMapWidthHeight((Envelope)bbox);
                widthList.add(String.valueOf(imageBox[0]));
                heightList.add(String.valueOf(imageBox[1]));
                coverageStatus.add(LAYER_IS_VECTOR);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error trying to access layer " + layer.getName(), e);
            }
        }
        for (FeatureTypeInfo layer : ctypes) {
            try {
                double[] lowerLeft = layer.getEnvelope().getLowerCorner().getCoordinates();
                double[] upperRight = layer.getEnvelope().getUpperCorner().getCoordinates();
                bbox = new Envelope(lowerLeft[0], upperRight[0], lowerLeft[1], upperRight[1]);
                if (!layer.isEnabled()) continue;
                String shortLayerName = layer.getName().split(":")[1];
                ftList.add(layer.getNameSpace().getPrefix() + "_" + shortLayerName);
                ftnsList.add(layer.getNameSpace().getPrefix() + ":" + shortLayerName);
                dsList.add(layer.getFormatInfo().getId());
                bboxList.add(bbox.getMinX() + "," + bbox.getMinY() + "," + bbox.getMaxX() + "," + bbox.getMaxY());
                srsList.add(layer.getSrsName());
                int[] imageBox = this.getMapWidthHeight((Envelope)bbox);
                widthList.add(String.valueOf(imageBox[0]));
                heightList.add(String.valueOf(imageBox[1]));
                coverageStatus.add(LAYER_IS_COVERAGE);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error trying to access layer " + layer.getName(), e);
            }
        }
        Locale locale = request.getLocale();
        MessageResources messages = this.getResources(request);
        String baseMap = messages.getMessage(locale, "label.baseMap");
        for (String baseMapTitle : bmtypes) {
            try {
                ftList.add(baseMapTitle);
                ftnsList.add(baseMapTitle);
                dsList.add(baseMap);
                GeneralEnvelope bmBbox = (GeneralEnvelope)wms.getBaseMapEnvelopes().get(baseMapTitle);
                Envelope bbox2 = new Envelope(bmBbox.getMinimum(0), bmBbox.getMaximum(0), bmBbox.getMinimum(1), bmBbox.getMaximum(1));
                bboxList.add(bbox2.getMinX() + "," + bbox2.getMinY() + "," + bbox2.getMaxX() + "," + bbox2.getMaxY());
                try {
                    Integer epsgCode = CRS.lookupEpsgCode((CoordinateReferenceSystem)bmBbox.getCoordinateReferenceSystem(), (boolean)false);
                    if (epsgCode != null) {
                        srsList.add("EPSG:" + epsgCode);
                    }
                }
                catch (FactoryException e) {
                    throw (IOException)new IOException().initCause(e);
                }
                int[] imageBox = this.getMapWidthHeight(bbox2);
                widthList.add(String.valueOf(imageBox[0]));
                heightList.add(String.valueOf(imageBox[1]));
                coverageStatus.add(this.computeGroupCoverageStatus(wms, baseMapTitle));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error trying to access group " + baseMapTitle, e);
            }
        }
        ArrayList<String> escapedFtnsist = new ArrayList<String>();
        for (String ft : ftnsList) {
            escapedFtnsist.add(URLEncoder.encode(ft, "UTF-8"));
        }
        DynaActionForm myForm = (DynaActionForm)form;
        myForm.set("DSNameList", (Object)dsList.toArray(new String[dsList.size()]));
        myForm.set("FTNameList", (Object)ftList.toArray(new String[ftList.size()]));
        myForm.set("BBoxList", (Object)bboxList.toArray(new String[bboxList.size()]));
        myForm.set("SRSList", (Object)srsList.toArray(new String[srsList.size()]));
        myForm.set("WidthList", (Object)widthList.toArray(new String[widthList.size()]));
        myForm.set("HeightList", (Object)heightList.toArray(new String[heightList.size()]));
        myForm.set("FTNamespaceList", (Object)ftnsList.toArray(new String[ftnsList.size()]));
        myForm.set("EscapedFTNamespaceList", (Object)ftnsList.toArray(new String[escapedFtnsist.size()]));
        myForm.set("CoverageStatus", (Object)coverageStatus.toArray(new Integer[coverageStatus.size()]));
        GeoServer gs = (GeoServer)GeoServerExtensions.extensions(GeoServer.class).get(0);
        myForm.set("BaseUrl", (Object)"");
        return mapping.findForward("success");
    }

    private Integer computeGroupCoverageStatus(WMS wms, String baseMapTitle) {
        String layerParam = (String)wms.getBaseMapLayers().get(baseMapTitle);
        String[] layers = layerParam.split(",");
        int coverageCount = 0;
        for (int i = 0; i < layers.length; ++i) {
            if (wms.getData().getLayerType(layers[i]) != Data.TYPE_RASTER) continue;
            ++coverageCount;
        }
        if (coverageCount == 0) {
            return LAYER_IS_VECTOR;
        }
        if (coverageCount < layers.length) {
            return LAYER_HAS_COVERAGE;
        }
        return LAYER_IS_COVERAGE;
    }

    private int[] getMapWidthHeight(Envelope bbox) {
        int height;
        int width;
        double ratio = bbox.getHeight() / bbox.getWidth();
        if (ratio < 1.0) {
            width = 750;
            height = (int)Math.round(750.0 * ratio);
        } else {
            width = (int)Math.round(550.0 / ratio);
            height = 550;
        }
        if (width < 300) {
            width = 300;
        }
        if (height < 300) {
            height = 300;
        }
        return new int[]{width + 50, height};
    }
}

