/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.geotools.factory.Hints;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.vfny.geoserver.crs.GeoserverCustomWKTFactory;

public class SrsHelpAction
extends Action {
    private static final Logger LOGGER = Logging.getLogger((String)SrsHelpAction.class.getName());

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ArrayList<String> defs = new ArrayList<String>();
        ArrayList<String> ids_string = new ArrayList<String>();
        Set codes = CRS.getSupportedCodes((String)"EPSG");
        CRSAuthorityFactory customFactory = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"EPSG", (Hints)new Hints((RenderingHints.Key)Hints.CRS_AUTHORITY_FACTORY, GeoserverCustomWKTFactory.class));
        Set customCodes = new HashSet();
        try {
            customCodes = customFactory.getAuthorityCodes(CoordinateReferenceSystem.class);
        }
        catch (FactoryException e) {
            LOGGER.log(Level.WARNING, "Error occurred while trying to gather custom CRS codes", e);
        }
        HashSet<String> idSet = new HashSet<String>();
        for (String code : codes) {
            String id = code.substring(code.indexOf(58) + 1);
            idSet.add(id);
        }
        ArrayList ids = new ArrayList(idSet);
        Collections.sort(ids);
        for (String id : ids) {
            try {
                CoordinateReferenceSystem crs = CRS.decode((String)("EPSG:" + id));
                String def = crs.toString();
                defs.add(def);
                ids_string.add(id.toString());
            }
            catch (Exception e) {
                if (customCodes.contains(id.toString())) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Issues converting EPSG:" + id + ".", e);
                        continue;
                    }
                    LOGGER.log(Level.WARNING, "Issues converting EPSG:" + id + ". " + e.getLocalizedMessage() + " Stack trace included at FINE logging level");
                    continue;
                }
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.log(Level.FINER, "Issues converting EPSG:" + id, e);
            }
        }
        DynaActionForm myForm = (DynaActionForm)form;
        myForm.set("srsDefinitionList", (Object)defs.toArray(new String[defs.size()]));
        myForm.set("srsIDList", (Object)ids_string.toArray(new String[ids_string.size()]));
        return mapping.findForward("success");
    }
}

