/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action.data;

import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.DataStoreConfig;
import org.vfny.geoserver.config.FeatureTypeConfig;
import org.vfny.geoserver.config.NameSpaceConfig;
import org.vfny.geoserver.config.WMSConfig;
import org.vfny.geoserver.form.data.DataFeatureTypesSelectForm;
import org.vfny.geoserver.global.UserContainer;

public class DataFeatureTypesSelectAction
extends ConfigAction {
    public ActionForward execute(ActionMapping mapping, ActionForm incomingForm, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DataFeatureTypesSelectForm form = (DataFeatureTypesSelectForm)incomingForm;
        String selectedFeatureType = form.getSelectedFeatureTypeName();
        String buttonAction = form.getButtonAction();
        DataConfig dataConfig = (DataConfig)this.getServlet().getServletContext().getAttribute("Config.Data");
        FeatureTypeConfig ftConfig = dataConfig.getFeatureTypeConfig(selectedFeatureType);
        request.getSession().removeAttribute("selectedAttributeType");
        Locale locale = request.getLocale();
        MessageResources messages = this.getResources(request);
        String edit = messages.getMessage(locale, "label.edit");
        String delete = messages.getMessage(locale, "label.delete");
        if (edit.equals(buttonAction)) {
            request.getSession().setAttribute("selectedFeatureType", (Object)ftConfig);
            user.setFeatureTypeConfig(ftConfig);
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info(new StringBuffer("setting session and user ftConfig to : ").append(ftConfig).toString());
            }
            return mapping.findForward("config.data.type.editor");
        }
        if (delete.equals(buttonAction)) {
            String group = this.featureTypeInGroup(dataConfig, selectedFeatureType);
            if (group != null) {
                ActionErrors errors = new ActionErrors();
                errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.delete.layer.in.group", (Object)selectedFeatureType, (Object)group));
                this.saveErrors(request, errors);
            } else {
                dataConfig.removeFeatureType(selectedFeatureType);
                request.getSession().removeAttribute("selectedFeatureType");
                this.getApplicationState().notifyConfigChanged();
            }
            return mapping.findForward("config.data.type");
        }
        throw new ServletException("Action must be a MessageResource key value of either 'label.edit' or 'label.delete'");
    }

    private String featureTypeInGroup(DataConfig dataConfig, String selectedFeatureType) {
        FeatureTypeConfig ft = dataConfig.getFeatureTypeConfig(selectedFeatureType);
        String name = ft.getName();
        DataStoreConfig ds = dataConfig.getDataStore(ft.getDataStoreId());
        NameSpaceConfig ns = dataConfig.getNameSpace(ds.getNameSpaceId());
        String qualifiedName = ns.getPrefix() + ":" + name;
        WMSConfig config = this.getWMSConfig();
        for (String group : config.getBaseMapLayers().keySet()) {
            String layers = (String)config.getBaseMapLayers().get(group);
            String[] layerNames = layers.split(",");
            for (int i = 0; i < layerNames.length; ++i) {
                if (!layerNames[i].equals(name) && !layerNames[i].equals(qualifiedName)) continue;
                return group;
            }
        }
        return null;
    }
}

