/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action.data;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.vfny.geoserver.action.ConfigAction;
import org.vfny.geoserver.action.HTMLEncoder;
import org.vfny.geoserver.config.AttributeTypeInfoConfig;
import org.vfny.geoserver.config.ConfigRequests;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.DataStoreConfig;
import org.vfny.geoserver.config.FeatureTypeConfig;
import org.vfny.geoserver.form.data.AttributeForm;
import org.vfny.geoserver.form.data.TypesEditorForm;
import org.vfny.geoserver.global.FeatureTypeInfo;
import org.vfny.geoserver.global.MetaDataLink;
import org.vfny.geoserver.global.UserContainer;
import org.vfny.geoserver.util.DataStoreUtils;

public class TypesEditorAction
extends ConfigAction {
    public ActionForward execute(ActionMapping mapping, ActionForm form, UserContainer user, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(new StringBuffer("form bean:").append(form.getClass().getName()).toString());
        }
        TypesEditorForm typeForm = (TypesEditorForm)form;
        String action = typeForm.getAction();
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(new StringBuffer("TypesEditorAction is ").append(action).toString());
        }
        Locale locale = request.getLocale();
        MessageResources messages = this.getResources(request);
        String SUBMIT = HTMLEncoder.decode((String)messages.getMessage(locale, "label.submit"));
        String ADD = HTMLEncoder.decode((String)messages.getMessage(locale, "label.add"));
        String BBOX = HTMLEncoder.decode((String)messages.getMessage(locale, "config.data.calculateBoundingBox.label"));
        String LOOKUP_SRS = HTMLEncoder.decode((String)messages.getMessage(locale, "config.data.lookupSRS.label"));
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(new StringBuffer("BBOX: ").append(BBOX).toString());
        }
        String NEWSLD = HTMLEncoder.decode((String)messages.getMessage(locale, "config.data.sldWizard.label"));
        if (typeForm.getAutoGenerateExtent().equals("true")) {
            if (typeForm.getSRS() == null || typeForm.getSRS().trim().equals("0")) {
                this.executeLookupSRS(mapping, typeForm, user, request);
            }
            this.executeBBox(mapping, typeForm, user, request);
            return this.executeSubmit(mapping, typeForm, user, request);
        }
        if (SUBMIT.equals(action)) {
            return this.executeSubmit(mapping, typeForm, user, request);
        }
        if (action.equals(BBOX)) {
            return this.executeBBox(mapping, typeForm, user, request);
        }
        if (action.equals(LOOKUP_SRS)) {
            return this.executeLookupSRS(mapping, typeForm, user, request);
        }
        if (action.equals(NEWSLD)) {
            return mapping.findForward("SLDWizard");
        }
        List attributes = typeForm.getAttributes();
        if (action.startsWith("up_")) {
            int index = Integer.parseInt(action.substring(3));
            Object attribute = attributes.remove(index);
            attributes.add(index - 1, attribute);
        } else if (action.startsWith("down_")) {
            int index = Integer.parseInt(action.substring(5));
            Object attribute = attributes.remove(index);
            attributes.add(index + 1, attribute);
        } else if (action.startsWith("delete_")) {
            int index = Integer.parseInt(action.substring(7));
            attributes.remove(index);
        } else if (action.equals(ADD)) {
            this.executeAdd(mapping, typeForm, user, request);
        }
        this.sync(typeForm, user.getFeatureTypeConfig(), request);
        form.reset(mapping, request);
        return mapping.findForward("config.data.type.editor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionForward executeLookupSRS(ActionMapping mapping, TypesEditorForm typeForm, UserContainer user, HttpServletRequest request) throws IOException, ServletException {
        DataConfig dataConfig = this.getDataConfig();
        DataStoreConfig dsConfig = dataConfig.getDataStore(typeForm.getDataStoreId());
        DataStore dataStore = null;
        try {
            dataStore = dsConfig.findDataStore(request.getSession().getServletContext());
            SimpleFeatureType featureType = dataStore.getSchema(typeForm.getTypeName());
            FeatureSource fs = dataStore.getFeatureSource(featureType.getTypeName());
            CoordinateReferenceSystem crs = ((SimpleFeatureType)fs.getSchema()).getCoordinateReferenceSystem();
            String s = CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)true);
            if (s == null) {
                typeForm.setSRS("UNKNOWN");
            } else if (s.indexOf(58) != -1) {
                typeForm.setSRS(s.substring(s.indexOf(58) + 1));
            } else {
                typeForm.setSRS(s);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Error occurred trying to lookup the SRS", e);
            typeForm.setSRS("UNKNOWN");
        }
        finally {
            if (dataStore != null) {
                dataStore.dispose();
            }
        }
        return mapping.findForward("config.data.type.editor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ActionForward executeBBox(ActionMapping mapping, TypesEditorForm typeForm, UserContainer user, HttpServletRequest request) throws IOException, ServletException {
        ActionForward actionForward;
        ActionErrors errors;
        DataConfig dataConfig = this.getDataConfig();
        DataStoreConfig dsConfig = dataConfig.getDataStore(typeForm.getDataStoreId());
        DataStore dataStore = null;
        try {
            MathTransform xform;
            Envelope envelope;
            dataStore = dsConfig.findDataStore(request.getSession().getServletContext());
            SimpleFeatureType featureType = dataStore.getSchema(typeForm.getTypeName());
            FeatureSource fs = dataStore.getFeatureSource(featureType.getTypeName());
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("calculating bbox for their dataset").toString());
            }
            if ((envelope = DataStoreUtils.getBoundingBoxEnvelope((FeatureSource)fs)).isNull()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(new StringBuffer("SimpleFeatureType '").append(featureType.getTypeName()).append("' has a null bounding box").toString());
                }
                ActionErrors errors2 = new ActionErrors();
                errors2.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.data.nullBBOX", (Object)featureType.getTypeName()));
                this.saveErrors(request, errors2);
                ActionForward actionForward2 = mapping.findForward("config.data.type.editor");
                return actionForward2;
            }
            String srs = typeForm.getSRS();
            if (srs.indexOf(58) == -1) {
                srs = "EPSG:" + srs;
            }
            CoordinateReferenceSystem crsDeclared = CRS.decode((String)srs);
            CoordinateReferenceSystem original = null;
            if (featureType.getGeometryDescriptor() != null) {
                original = featureType.getCoordinateReferenceSystem();
            }
            if (original == null) {
                original = crsDeclared;
            }
            CoordinateReferenceSystem crsLatLong = CRS.decode((String)"EPSG:4326");
            Envelope declaredEnvelope = envelope;
            if (!CRS.equalsIgnoreMetadata((Object)original, (Object)crsDeclared)) {
                if (typeForm.getSrsHandlingCode() == FeatureTypeInfo.REPROJECT) {
                    xform = CRS.findMathTransform((CoordinateReferenceSystem)original, (CoordinateReferenceSystem)crsDeclared, (boolean)true);
                    declaredEnvelope = JTS.transform((Envelope)envelope, null, (MathTransform)xform, (int)10);
                } else if (typeForm.getSrsHandlingCode() == FeatureTypeInfo.FORCE) {
                    declaredEnvelope = new ReferencedEnvelope(envelope, crsDeclared);
                }
            }
            LOGGER.finer("Seeting form's data envelope: " + declaredEnvelope);
            typeForm.setDataMinX(Double.toString(declaredEnvelope.getMinX()));
            typeForm.setDataMaxX(Double.toString(declaredEnvelope.getMaxX()));
            typeForm.setDataMinY(Double.toString(declaredEnvelope.getMinY()));
            typeForm.setDataMaxY(Double.toString(declaredEnvelope.getMaxY()));
            xform = CRS.findMathTransform((CoordinateReferenceSystem)original, (CoordinateReferenceSystem)crsLatLong, (boolean)true);
            Envelope xformed_envelope = JTS.transform((Envelope)envelope, (MathTransform)xform);
            typeForm.setMinX(Double.toString(xformed_envelope.getMinX()));
            typeForm.setMaxX(Double.toString(xformed_envelope.getMaxX()));
            typeForm.setMinY(Double.toString(xformed_envelope.getMinY()));
            typeForm.setMaxY(Double.toString(xformed_envelope.getMaxY()));
        }
        catch (NoSuchAuthorityCodeException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(e.getLocalizedMessage());
                LOGGER.fine(e.getStackTrace().toString());
            }
            errors = new ActionErrors();
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.data.couldNotFindSRSAuthority", (Object)e.getLocalizedMessage(), (Object)e.getAuthorityCode()));
            this.saveErrors(request, errors);
            actionForward = mapping.findForward("config.data.type.editor");
            return actionForward;
        }
        catch (FactoryException fe) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(fe.getLocalizedMessage());
                LOGGER.fine(fe.getStackTrace().toString());
            }
            errors = new ActionErrors();
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.data.factoryException", (Object)fe.getLocalizedMessage()));
            this.saveErrors(request, errors);
            actionForward = mapping.findForward("config.data.type.editor");
            return actionForward;
        }
        catch (TransformException te) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(te.getLocalizedMessage());
                LOGGER.fine(te.getStackTrace().toString());
            }
            errors = new ActionErrors();
            errors.add("org.apache.struts.action.GLOBAL_ERROR", new ActionError("error.data.transformException"));
            this.saveErrors(request, errors);
            actionForward = mapping.findForward("config.data.type.editor");
            return actionForward;
        }
        finally {
            if (dataStore != null) {
                dataStore.dispose();
            }
        }
        return mapping.findForward("config.data.type.editor");
    }

    private void sync(TypesEditorForm form, FeatureTypeConfig config, HttpServletRequest request) {
        String schemaBase;
        config.setName(form.getTypeName());
        if (form.getAlias() != null && "".equals(form.getAlias().trim())) {
            config.setAlias(null);
        } else {
            config.setAlias(form.getAlias());
        }
        config.setAbstract(form.getAbstract());
        config.setDefaultStyle(form.getStyleId());
        config.getStyles().clear();
        if (form.getOtherSelectedStyles() != null) {
            for (int i = 0; i < form.getOtherSelectedStyles().length; ++i) {
                config.addStyle(form.getOtherSelectedStyles()[i]);
            }
        }
        config.setSRS(Integer.parseInt(form.getSRS()));
        config.setTitle(form.getTitle());
        Envelope latLonBbox = this.getBoundingBox(form);
        if (!config.getLatLongBBox().equals((Object)latLonBbox) || config.getSRS() != Integer.parseInt(form.getSRS())) {
            config.setLatLongBBox(latLonBbox);
            try {
                Envelope nativeBBox = this.convertBBoxFromLatLon(latLonBbox, "EPSG: " + config.getSRS());
                config.setNativeBBox(nativeBBox);
            }
            catch (Exception e) {
                LOGGER.severe("Couldn't convert new BBox to native coordinate system! Error was" + e);
            }
        } else {
            config.setNativeBBox(this.getNativeBBox(form));
        }
        config.setKeywords(this.keyWords(form));
        config.setMetadataLinks(this.metadataLinks(form));
        config.setWmsPath(form.getWmsPath());
        config.setCacheMaxAge(form.getCacheMaxAge());
        config.setCachingEnabled(form.isCachingEnabled());
        config.setIndexingEnabled(form.isIndexingEnabled());
        config.setMaxFeatures(Integer.parseInt(form.getMaxFeatures()));
        config.setRegionateAttribute(form.getRegionateAttribute());
        config.setRegionateStrategy(form.getRegionateStrategy());
        try {
            config.setRegionateFeatureLimit(Integer.valueOf(form.getRegionateFeatureLimit()).intValue());
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        config.setSRSHandling(form.getSrsHandlingCode());
        if (!form.isCachingEnabledChecked()) {
            config.setCachingEnabled(false);
        }
        if (!form.isIndexingEnabledChecked()) {
            config.setIndexingEnabled(false);
        }
        if ((schemaBase = form.getSchemaBase()) == null || schemaBase.equals("") || schemaBase.equals("--")) {
            config.setSchemaBase(null);
            config.setSchemaName(null);
            config.setSchemaAttributes(null);
        } else {
            config.setSchemaBase(schemaBase);
            String schemaName = config.getSchemaName();
            ArrayList<AttributeTypeInfoConfig> schemaAttributes = config.getSchemaAttributes();
            System.out.println("in non null sb, sname: " + schemaName + ", satts: " + schemaAttributes);
            if (schemaName == null || schemaName.trim().length() == 0) {
                schemaName = form.getTypeName() + "_Type";
                schemaAttributes = null;
                config.setSchemaName(schemaName);
            } else {
                config.setSchemaName(form.getSchemaName());
            }
            if (schemaAttributes == null || schemaAttributes.isEmpty()) {
                schemaAttributes = new ArrayList<AttributeTypeInfoConfig>();
                List createList = form.getCreateableAttributes();
                System.out.println("schemaAtts null, createList: " + createList);
                SimpleFeatureType fType = this.getFeatureType(form, request);
                for (int i = 0; i < fType.getAttributeCount(); ++i) {
                    AttributeDescriptor attType = fType.getDescriptor(i);
                    AttributeTypeInfoConfig attributeConfig = new AttributeTypeInfoConfig(attType);
                    schemaAttributes.add(attributeConfig);
                }
                config.setSchemaAttributes(schemaAttributes);
            } else {
                config.setSchemaAttributes(form.toSchemaAttributes());
            }
        }
        LOGGER.fine("config schema atts is " + config.getSchemaAttributes());
    }

    private Envelope convertBBoxFromLatLon(Envelope latLonBbox, String crsName) throws Exception {
        CoordinateReferenceSystem latLon = CRS.decode((String)"EPSG:4326");
        CoordinateReferenceSystem nativeCRS = CRS.decode((String)crsName);
        Envelope env = null;
        if (!CRS.equalsIgnoreMetadata((Object)latLon, (Object)nativeCRS)) {
            MathTransform xform = CRS.findMathTransform((CoordinateReferenceSystem)latLon, (CoordinateReferenceSystem)nativeCRS, (boolean)true);
            env = JTS.transform((Envelope)latLonBbox, null, (MathTransform)xform, (int)10);
        } else {
            env = latLonBbox;
        }
        return env;
    }

    private void executeAdd(ActionMapping mapping, TypesEditorForm form, UserContainer user, HttpServletRequest request) {
        String attributeName = form.getNewAttribute();
        SimpleFeatureType fType = this.getFeatureType(form, request);
        AttributeForm newAttribute = this.newAttributeForm(attributeName, fType);
        form.getAttributes().add(newAttribute);
    }

    private AttributeForm newAttributeForm(String attributeName, SimpleFeatureType featureType) {
        AttributeDescriptor attributeType = featureType.getDescriptor(attributeName);
        AttributeTypeInfoConfig attributeConfig = new AttributeTypeInfoConfig(attributeType);
        AttributeForm newAttribute = new AttributeForm(attributeConfig, attributeType);
        return newAttribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleFeatureType getFeatureType(TypesEditorForm form, HttpServletRequest request) {
        SimpleFeatureType featureType = null;
        DataStore dataStore = null;
        try {
            DataConfig config = ConfigRequests.getDataConfig((HttpServletRequest)request);
            DataStoreConfig dataStoreConfig = config.getDataStore(form.getDataStoreId());
            dataStore = dataStoreConfig.findDataStore(this.getServlet().getServletContext());
            featureType = dataStore.getSchema(form.getTypeName());
        }
        catch (IOException e) {
        }
        finally {
            if (dataStore != null) {
                dataStore.dispose();
            }
        }
        return featureType;
    }

    private ActionForward executeSubmit(ActionMapping mapping, TypesEditorForm form, UserContainer user, HttpServletRequest request) {
        FeatureTypeConfig config = user.getFeatureTypeConfig();
        DataConfig dataConfig = this.getDataConfig();
        String keyName = config.getDataStoreId() + ":" + config.getName();
        String keyAlias = config.getDataStoreId() + ":" + config.getAlias();
        FeatureTypeConfig oldConfig = dataConfig.getFeatureTypeConfig(keyName);
        if (oldConfig != null && oldConfig == config) {
            dataConfig.removeFeatureType(keyName);
        }
        if (config.getAlias() != null && (oldConfig = dataConfig.getFeatureTypeConfig(keyAlias)) != null && oldConfig == config) {
            dataConfig.removeFeatureType(keyAlias);
        }
        this.sync(form, config, request);
        keyName = config.getDataStoreId() + ":" + config.getName();
        keyAlias = config.getDataStoreId() + ":" + config.getAlias();
        if (config.getAlias() != null && !"".equals(config.getAlias())) {
            dataConfig.addFeatureType(keyAlias, config);
        } else {
            dataConfig.addFeatureType(keyName, config);
        }
        this.getApplicationState().notifyConfigChanged();
        user.setFeatureTypeConfig(null);
        return mapping.findForward("config.data.type");
    }

    private Envelope getBoundingBox(TypesEditorForm typeForm) {
        return new Envelope(Double.parseDouble(typeForm.getMinX()), Double.parseDouble(typeForm.getMaxX()), Double.parseDouble(typeForm.getMinY()), Double.parseDouble(typeForm.getMaxY()));
    }

    private Envelope getNativeBBox(TypesEditorForm typeForm) {
        try {
            return new Envelope(Double.parseDouble(typeForm.getDataMinX()), Double.parseDouble(typeForm.getDataMaxX()), Double.parseDouble(typeForm.getDataMinY()), Double.parseDouble(typeForm.getDataMaxY()));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private Set keyWords(TypesEditorForm typeForm) {
        HashSet<String> keywords = new HashSet<String>();
        String[] array = typeForm.getKeywords() != null ? typeForm.getKeywords().split(",") : new String[]{};
        for (int i = 0; i < array.length; ++i) {
            keywords.add(array[i].trim());
        }
        return keywords;
    }

    private Set metadataLinks(TypesEditorForm typeForm) {
        HashSet<MetaDataLink> links = new HashSet<MetaDataLink>();
        MetaDataLink link = this.getLink(typeForm, 0);
        if (link != null) {
            links.add(link);
        }
        if ((link = this.getLink(typeForm, 1)) != null) {
            links.add(link);
        }
        return links;
    }

    private MetaDataLink getLink(TypesEditorForm typeForm, int index) {
        MetaDataLink link = typeForm.getMetadataLink(index);
        if (link.getContent() == null || link.getContent().trim().equals("")) {
            return null;
        }
        return link;
    }

    DataStore aquireDataStore(String dataStoreID) throws IOException {
        DataConfig dataConfig = this.getDataConfig();
        DataStoreConfig dataStoreConfig = dataConfig.getDataStore(dataStoreID);
        Map params = dataStoreConfig.getConnectionParams();
        return DataStoreUtils.getDataStore((Map)params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SimpleFeatureType getSchema(String dataStoreID, String typeName) throws IOException {
        DataStore dataStore = null;
        try {
            dataStore = this.aquireDataStore(dataStoreID);
            SimpleFeatureType simpleFeatureType = dataStore.getSchema(typeName);
            return simpleFeatureType;
        }
        finally {
            if (dataStore != null) {
                dataStore.dispose();
            }
        }
    }
}

