/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.action.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.data.Repository;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.geotools.validation.ValidationProcessor;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.Validator;
import org.vfny.geoserver.action.validation.TestValidationResults;
import org.vfny.geoserver.config.DataConfig;
import org.vfny.geoserver.config.DataStoreConfig;

public class ValidationRunnable
implements Runnable {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses");
    private Map testSuites;
    private Map plugins;
    private DataConfig dataConfig;
    private ServletContext context;
    private HttpServletRequest request;
    Validator validator;
    ValidationProcessor gv;
    public TestValidationResults results;
    Repository repository;
    public static final String KEY = "validationTestDoItThread.key";

    public ValidationRunnable(HttpServletRequest request) {
        this.request = request;
    }

    public void setup(TestValidationResults vr, Repository repo, Map plugins, Map testSuites) throws Exception {
        this.gv = new ValidationProcessor();
        this.gv.load(plugins, testSuites);
        this.results = vr;
        this.repository = repo;
        this.validator = new Validator(this.repository, this.gv);
    }

    public void run() {
        this.request.getSession().setAttribute("TestValidationResults", (Object)this.results);
        SortedMap dataStores = this.repository.getFeatureSources();
        for (Map.Entry entry : dataStores.entrySet()) {
            String typeRef = (String)entry.getKey();
            FeatureSource featureSource = (FeatureSource)entry.getValue();
            String dataStoreId = typeRef.split(":")[0];
            try {
                LOGGER.finer(dataStoreId + ": feature validation, " + featureSource);
                FeatureCollection features = featureSource.getFeatures();
                this.validator.featureValidation(dataStoreId, features, (ValidationResults)this.results);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        ReferencedEnvelope env = new ReferencedEnvelope(-2.147483648E9, -2.147483648E9, 2.147483647E9, 2.147483647E9, null);
        try {
            SortedMap featureSources = this.repository.getFeatureSources();
            LOGGER.finer("integrity tests entry for " + featureSources.size() + " dataSources.");
            this.validator.integrityValidation((Map)featureSources, env, (ValidationResults)this.results);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.results.run = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestValidationResults runTransactions(Map dsm, ValidationProcessor v, ServletContext sc) {
        TestValidationResults vr;
        block13: {
            if (dsm == null || dsm.size() == 0) {
                System.out.println("No Datastores were defined.");
                return null;
            }
            if (v == null) {
                System.err.println("An error occured: Cannot run without a ValidationProcessor.");
                return null;
            }
            vr = new TestValidationResults();
            Iterator i = dsm.keySet().iterator();
            ArrayList<DataStore> dataStores = new ArrayList<DataStore>();
            block7: while (true) {
                while (i.hasNext()) {
                    HashMap<String, FeatureSource> sources = new HashMap<String, FeatureSource>();
                    String key = i.next().toString();
                    DataStoreConfig dsc = (DataStoreConfig)dsm.get(key);
                    try {
                        DataStore ds = dsc.findDataStore(sc);
                        dataStores.add(ds);
                        String[] ss = ds.getTypeNames();
                        for (int j = 0; j < ss.length; ++j) {
                            FeatureSource fs = ds.getFeatureSource(ss[j]);
                            sources.put(dsc.getId() + ":" + ss[j], fs);
                            System.out.println("Feature Test Results for " + key + ":" + ss[j]);
                            System.out.println(vr.toString());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ReferencedEnvelope env = new ReferencedEnvelope(-2.147483648E9, -2.147483648E9, 2.147483647E9, 2.147483647E9, null);
                    try {
                        v.runIntegrityTests(sources.keySet(), sources, env, (ValidationResults)vr);
                        System.out.println("Feature Integrety Test Results");
                        System.out.println(vr.toString());
                        continue block7;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                break block13;
                {
                    continue block7;
                    break;
                }
                break;
            }
            finally {
                for (DataStore ds : dataStores) {
                    ds.dispose();
                }
            }
        }
        return vr;
    }
}

