/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config.web;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import org.apache.commons.digester.Digester;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.ModuleConfigFactory;
import org.springframework.core.io.Resource;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MultipleActionServlet
extends ActionServlet {
    private static final long serialVersionUID = -5222456011963238678L;

    public void init() throws ServletException {
        try {
            this.initInternal();
            this.initOther();
            this.initServlet();
            this.getServletContext().setAttribute("org.apache.struts.action.ACTION_SERVLET", (Object)this);
            this.initModuleConfigFactory();
            ModuleConfig moduleConfig = this.initModuleConfig("", this.config);
            this.initModuleMessageResources(moduleConfig);
            this.initModuleDataSources(moduleConfig);
            this.initModulePlugIns(moduleConfig);
            moduleConfig.freeze();
            Enumeration names = this.getServletConfig().getInitParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith("config/")) continue;
                String prefix = name.substring(6);
                moduleConfig = this.initModuleConfig(prefix, this.getServletConfig().getInitParameter(name));
                this.initModuleMessageResources(moduleConfig);
                this.initModuleDataSources(moduleConfig);
                this.initModulePlugIns(moduleConfig);
                moduleConfig.freeze();
            }
            this.initModulePrefixes(this.getServletContext());
            this.destroyConfigDigester();
        }
        catch (UnavailableException ex) {
            throw ex;
        }
        catch (Throwable t) {
            log.error((Object)"Unable to initialize Struts ActionServlet due to an unexpected exception or error thrown, so marking the servlet as unavailable.  Most likely, this is due to an incorrect or missing library dependency.", t);
            throw new UnavailableException(t.getMessage());
        }
    }

    protected ModuleConfig initModuleConfig(String prefix, String paths) throws ServletException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing module path '" + prefix + "' configuration from '" + paths + "'"));
        }
        ModuleConfigFactory factoryObject = ModuleConfigFactory.createFactory();
        ModuleConfig config = factoryObject.createModuleConfig(prefix);
        Digester digester = this.initConfigDigester();
        while (paths.length() > 0) {
            digester.push((Object)config);
            String path = null;
            int comma = paths.indexOf(44);
            if (comma >= 0) {
                path = paths.substring(0, comma).trim();
                paths = paths.substring(comma + 1);
            } else {
                path = paths.trim();
                paths = "";
            }
            if (path.length() < 1) break;
            this.parseModuleConfigFile(digester, path, config);
        }
        this.getServletContext().setAttribute("org.apache.struts.action.MODULE" + config.getPrefix(), (Object)config);
        FormBeanConfig[] fbs = config.findFormBeanConfigs();
        for (int i = 0; i < fbs.length; ++i) {
            if (!fbs[i].getDynamic()) continue;
            fbs[i].getDynaActionFormClass();
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseModuleConfigFile(Digester digester, String path, ModuleConfig config) throws UnavailableException {
        InputStream input = null;
        Resource[] resources = null;
        try {
            resources = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext()).getResources(path);
        }
        catch (IOException ex) {
            this.handleConfigException(path, (Exception)ex);
        }
        int length = resources.length;
        for (int i = 0; i < length; ++i) {
            try {
                URL url = resources[i].getURL();
                if (url == null) {
                    url = this.getClass().getResource(path);
                }
                if (url == null) {
                    String msg = this.internal.getMessage("configMissing", (Object)path);
                    log.error((Object)msg);
                    throw new UnavailableException(msg);
                }
                InputSource is = new InputSource(url.toExternalForm());
                input = url.openStream();
                is.setByteStream(input);
                digester.parse(is);
                continue;
            }
            catch (MalformedURLException e) {
                this.handleConfigException(path, (Exception)e);
                continue;
            }
            catch (IOException e) {
                this.handleConfigException(path, (Exception)e);
                continue;
            }
            catch (SAXException e) {
                this.handleConfigException(path, (Exception)e);
                continue;
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                        if (length > 1 && i < length - 1) {
                            digester.push((Object)config);
                        }
                    }
                    catch (IOException e) {
                        throw new UnavailableException(e.getMessage());
                    }
                }
            }
        }
    }

    private void handleConfigException(String path, Exception e) throws UnavailableException {
        String msg = this.internal.getMessage("configParse", (Object)path);
        log.error((Object)msg, (Throwable)e);
        throw new UnavailableException(msg);
    }
}

