/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.form.wfs;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.vfny.geoserver.config.WFSConfig;

public class WFSContentForm
extends ActionForm {
    private boolean enabled;
    private String onlineResource;
    private String describeURL;
    private int serviceLevel;
    private String[] selectedFeatures;
    private String[] features;
    private boolean srsXmlStyle;
    private boolean srsXmlStyleChecked = false;
    private boolean citeConformanceHacks;
    private boolean citeConformanceHacksChecked = false;
    private boolean featureBounding;
    private boolean featureBoundingChecked = false;
    private boolean enabledChecked = false;

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getOnlineResource() {
        return this.onlineResource;
    }

    public void setDescribeURL(String string) {
        this.describeURL = string;
    }

    public void setEnabled(boolean b) {
        this.enabledChecked = true;
        this.enabled = b;
    }

    public void setOnlineResource(String string) {
        this.onlineResource = string;
    }

    public String[] getFeatures() {
        return this.features;
    }

    public String[] getSelectedFeatures() {
        return this.selectedFeatures;
    }

    public void setFeatures(String[] strings) {
        this.features = strings;
    }

    public void setSelectedFeatures(String[] strings) {
        this.selectedFeatures = strings;
    }

    public void reset(ActionMapping arg0, HttpServletRequest arg1) {
        super.reset(arg0, arg1);
        this.enabledChecked = false;
        this.srsXmlStyleChecked = false;
        this.citeConformanceHacksChecked = false;
        this.featureBoundingChecked = false;
        ServletContext context = this.getServlet().getServletContext();
        WFSConfig config = (WFSConfig)context.getAttribute("Config.WFS");
        this.citeConformanceHacks = config.getCiteConformanceHacks();
        this.featureBounding = config.isFeatureBounding();
        this.serviceLevel = config.getServiceLevel();
        this.enabled = config.isEnabled();
        this.srsXmlStyle = config.isSrsXmlStyle();
        URL url = config.getOnlineResource();
        this.onlineResource = url != null ? url.toString() : "";
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.serviceLevel != 1 && this.serviceLevel != 15 && this.serviceLevel != 31) {
            errors.add("serviceLevel", new ActionError("error.serviceLevel.invalid"));
        }
        if (this.onlineResource == null || this.onlineResource.equals("")) {
            errors.add("onlineResource", new ActionError("error.wfs.onlineResource.required"));
        } else {
            try {
                URL url = new URL(this.onlineResource);
            }
            catch (MalformedURLException badURL) {
                errors.add("onlineResource", new ActionError("error.wfs.onlineResource.malformed", (Object)badURL));
            }
        }
        return errors;
    }

    public boolean isEnabledChecked() {
        return this.enabledChecked;
    }

    public void setEnabledChecked(boolean b) {
        this.enabledChecked = b;
    }

    public boolean isSrsXmlStyleChecked() {
        return this.srsXmlStyleChecked;
    }

    public void setSrsXmlStyleChecked(boolean b) {
        this.srsXmlStyleChecked = b;
    }

    public int getServiceLevel() {
        return this.serviceLevel;
    }

    public void setServiceLevel(int serviceLevel) {
        this.serviceLevel = serviceLevel;
    }

    public boolean isSrsXmlStyle() {
        return this.srsXmlStyle;
    }

    public void setSrsXmlStyle(boolean doXmlStyle) {
        this.srsXmlStyleChecked = true;
        this.srsXmlStyle = doXmlStyle;
    }

    public void setCiteConformanceHacks(boolean on) {
        this.citeConformanceHacksChecked = true;
        this.citeConformanceHacks = on;
    }

    public boolean getCiteConformanceHacks() {
        return this.citeConformanceHacks;
    }

    public boolean getCiteConformanceHacksChecked() {
        return this.citeConformanceHacksChecked;
    }

    public void setFeatureBounding(boolean on) {
        this.featureBoundingChecked = true;
        this.featureBounding = on;
    }

    public boolean isFeatureBounding() {
        return this.featureBounding;
    }

    public boolean isFeatureBoundingChecked() {
        return this.featureBoundingChecked;
    }
}

