/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.jaxb.MarshalContext;
import org.geotoolkit.metadata.AbstractMetadata;
import org.geotoolkit.metadata.MetadataStandard;
import org.geotoolkit.metadata.UnmodifiableMetadataException;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.collection.CheckedArrayList;
import org.geotoolkit.util.collection.CheckedHashSet;
import org.geotoolkit.util.collection.UnmodifiableArrayList;
import org.geotoolkit.util.collection.XCollections;
import org.geotoolkit.util.logging.Logging;
import org.opengis.util.CodeList;

@ThreadSafe
public abstract class ModifiableMetadata
extends AbstractMetadata
implements Cloneable {
    private static final ModifiableMetadata FREEZING = new Null();
    private transient ModifiableMetadata unmodifiable;

    protected ModifiableMetadata() {
    }

    protected ModifiableMetadata(Object object) throws ClassCastException, UnmodifiableMetadataException {
        super(object);
    }

    protected ModifiableMetadata clone() throws CloneNotSupportedException {
        return (ModifiableMetadata)super.clone();
    }

    @Override
    public void prune() throws UnmodifiableMetadataException {
        super.prune();
    }

    @Override
    public final boolean isModifiable() {
        return this.unmodifiable != this;
    }

    public synchronized AbstractMetadata unmodifiable() {
        if (this.unmodifiable == null) {
            ModifiableMetadata modifiableMetadata;
            try {
                modifiableMetadata = this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                Logging.unexpectedException((Logger)LOGGER, this.getClass(), (String)"unmodifiable", (Throwable)cloneNotSupportedException);
                return this;
            }
            modifiableMetadata.freeze();
            this.unmodifiable = modifiableMetadata;
        }
        assert (!this.unmodifiable.isModifiable());
        return this.unmodifiable;
    }

    static Object unmodifiable(Object object) {
        if (object instanceof ModifiableMetadata) {
            return ((ModifiableMetadata)object).unmodifiable();
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            boolean bl = collection instanceof Set;
            if (collection.isEmpty()) {
                collection = bl ? Collections.EMPTY_SET : Collections.EMPTY_LIST;
            } else {
                Object[] objectArray = collection.toArray();
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = ModifiableMetadata.unmodifiable(objectArray[i]);
                }
                collection = UnmodifiableArrayList.wrap((Object[])objectArray);
                if (bl) {
                    collection = XCollections.unmodifiableSet(new LinkedHashSet(collection));
                }
            }
            return collection;
        }
        if (object instanceof Map) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)object;
            if (linkedHashMap.isEmpty()) {
                return Collections.EMPTY_MAP;
            }
            linkedHashMap = new LinkedHashMap(linkedHashMap);
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                entry.setValue(ModifiableMetadata.unmodifiable(entry.getValue()));
            }
            return XCollections.unmodifiableMap(linkedHashMap);
        }
        if (object instanceof org.geotoolkit.util.Cloneable) {
            return ((org.geotoolkit.util.Cloneable)object).clone();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void freeze() {
        if (this.isModifiable()) {
            ModifiableMetadata modifiableMetadata = null;
            try {
                this.unmodifiable = FREEZING;
                this.getStandard().freeze(this);
                modifiableMetadata = this;
            }
            finally {
                this.unmodifiable = modifiableMetadata;
            }
        }
    }

    protected void checkWritePermission() throws UnmodifiableMetadataException {
        assert (Thread.holdsLock(this));
        if (!this.isModifiable()) {
            throw new UnmodifiableMetadataException(Errors.format((int)230));
        }
        this.invalidate();
    }

    @Override
    final void invalidate() {
        super.invalidate();
        this.unmodifiable = null;
    }

    private static boolean isModifiable(Collection<?> collection) {
        if (!collection.isEmpty()) {
            try {
                collection.clear();
                return true;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return false;
    }

    protected final <E> List<E> copyList(Collection<? extends E> collection, List<E> object, Class<E> clazz) throws UnmodifiableMetadataException {
        if (collection != object) {
            if (this.unmodifiable == FREEZING) {
                assert (!ModifiableMetadata.isModifiable(collection));
                return (List)collection;
            }
            this.checkWritePermission();
            if (XCollections.isNullOrEmpty(collection)) {
                object = null;
            } else {
                if (object != null) {
                    object.clear();
                } else {
                    object = new MutableList<E>(clazz, collection.size());
                }
                object.addAll(collection);
            }
        }
        return object;
    }

    protected final <E> Set<E> copySet(Collection<? extends E> collection, Set<E> object, Class<E> clazz) throws UnmodifiableMetadataException {
        if (collection != object) {
            if (this.unmodifiable == FREEZING) {
                assert (!ModifiableMetadata.isModifiable(collection));
                return (Set)collection;
            }
            this.checkWritePermission();
            if (XCollections.isNullOrEmpty(collection)) {
                object = null;
            } else {
                if (object != null) {
                    object.clear();
                } else {
                    object = new MutableSet<E>(clazz, collection.size());
                }
                object.addAll(collection);
            }
        }
        return object;
    }

    protected final <E> Collection<E> copyCollection(Collection<? extends E> collection, Collection<E> object, Class<E> clazz) throws UnmodifiableMetadataException {
        if (collection != object) {
            if (this.unmodifiable == FREEZING) {
                assert (this.collectionType(clazz).isAssignableFrom(collection.getClass()));
                assert (!ModifiableMetadata.isModifiable(collection));
                return collection;
            }
            this.checkWritePermission();
            if (XCollections.isNullOrEmpty(collection)) {
                object = null;
            } else {
                if (object != null) {
                    object.clear();
                } else {
                    int n = collection.size();
                    object = this.useSet(clazz) ? new MutableSet<E>(clazz, n) : new MutableList<E>(clazz, n);
                }
                object.addAll(collection);
            }
        }
        return object;
    }

    private static boolean canReturnNull() {
        return MarshalContext.isMarshaling();
    }

    protected final <E> List<E> nonNullList(List<E> list, Class<E> clazz) {
        assert (Thread.holdsLock(this));
        if (list != null) {
            return list.isEmpty() && ModifiableMetadata.canReturnNull() ? null : list;
        }
        if (ModifiableMetadata.canReturnNull()) {
            return null;
        }
        if (this.isModifiable()) {
            return new MutableList<E>(clazz);
        }
        return Collections.emptyList();
    }

    protected final <E> Set<E> nonNullSet(Set<E> set, Class<E> clazz) {
        assert (Thread.holdsLock(this));
        if (set != null) {
            return set.isEmpty() && ModifiableMetadata.canReturnNull() ? null : set;
        }
        if (ModifiableMetadata.canReturnNull()) {
            return null;
        }
        if (this.isModifiable()) {
            return new MutableSet<E>(clazz);
        }
        return Collections.emptySet();
    }

    protected final <E> Collection<E> nonNullCollection(Collection<E> collection, Class<E> clazz) {
        assert (Thread.holdsLock(this));
        if (XCollections.isNullOrEmpty(collection) && MarshalContext.isMarshaling()) {
            return null;
        }
        if (collection != null) {
            assert (this.collectionType(clazz).isAssignableFrom(collection.getClass()));
            return collection.isEmpty() && ModifiableMetadata.canReturnNull() ? null : collection;
        }
        if (ModifiableMetadata.canReturnNull()) {
            return null;
        }
        boolean bl = this.isModifiable();
        if (this.useSet(clazz)) {
            if (bl) {
                return new MutableSet<E>(clazz);
            }
            return Collections.emptySet();
        }
        if (bl) {
            return new MutableList<E>(clazz);
        }
        return Collections.emptyList();
    }

    private <E> boolean useSet(Class<E> clazz) {
        Class<Collection<E>> clazz2 = this.collectionType(clazz);
        if (Set.class.isAssignableFrom(clazz2)) {
            return true;
        }
        if (List.class.isAssignableFrom(clazz2)) {
            return false;
        }
        throw new NoSuchElementException(Errors.format((int)240, clazz2));
    }

    protected <E> Class<? extends Collection<E>> collectionType(Class<E> clazz) {
        return CodeList.class.isAssignableFrom(clazz) || Enum.class.isAssignableFrom(clazz) ? Set.class : List.class;
    }

    private final class MutableList<E>
    extends CheckedArrayList<E> {
        private static final long serialVersionUID = -5016778173550153002L;

        public MutableList(Class<E> clazz) {
            super(clazz, 4);
        }

        public MutableList(Class<E> clazz, int n) {
            super(clazz, n);
        }

        protected Object getLock() {
            return ModifiableMetadata.this;
        }

        protected void checkWritePermission() throws UnsupportedOperationException {
            ModifiableMetadata.this.checkWritePermission();
        }
    }

    private final class MutableSet<E>
    extends CheckedHashSet<E> {
        private static final long serialVersionUID = 2337350768744454264L;

        public MutableSet(Class<E> clazz) {
            super(clazz, 4);
        }

        public MutableSet(Class<E> clazz, int n) {
            super(clazz, XCollections.hashMapCapacity((int)n));
        }

        protected Object getLock() {
            return ModifiableMetadata.this;
        }

        protected void checkWritePermission() throws UnsupportedOperationException {
            ModifiableMetadata.this.checkWritePermission();
        }
    }

    private static final class Null
    extends ModifiableMetadata {
        private Null() {
        }

        @Override
        public MetadataStandard getStandard() {
            return null;
        }
    }
}

