/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.jaxb.MarshalContext;
import org.geotoolkit.internal.jaxb.gmd.PT_Locale;
import org.geotoolkit.internal.jaxb.gmi.MI_Metadata;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.opengis.metadata.ApplicationSchemaInformation;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.MetadataExtensionInformation;
import org.opengis.metadata.PortrayalCatalogueReference;
import org.opengis.metadata.acquisition.AcquisitionInformation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.content.ContentInformation;
import org.opengis.metadata.distribution.Distribution;
import org.opengis.metadata.identification.CharacterSet;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.spatial.SpatialRepresentation;
import org.opengis.referencing.ReferenceSystem;

@ThreadSafe
@XmlType(name="MD_Metadata_Type", propOrder={"fileIdentifier", "language", "characterSet", "parentIdentifier", "hierarchyLevels", "hierarchyLevelNames", "contacts", "dateStamp", "metadataStandardName", "metadataStandardVersion", "dataSetUri", "locales", "spatialRepresentationInfo", "referenceSystemInfo", "metadataExtensionInfo", "identificationInfo", "contentInfo", "distributionInfo", "dataQualityInfo", "portrayalCatalogueInfo", "metadataConstraints", "applicationSchemaInfo", "metadataMaintenance", "acquisitionInformation"})
@XmlRootElement(name="MD_Metadata")
@XmlSeeAlso(value={MI_Metadata.class})
public class DefaultMetadata
extends MetadataEntity
implements Metadata {
    private static final long serialVersionUID = 7254025230235329493L;
    private String fileIdentifier;
    private Locale language;
    private Collection<Locale> locales;
    private CharacterSet characterSet;
    private String parentIdentifier;
    private Collection<ScopeCode> hierarchyLevels;
    private Collection<String> hierarchyLevelNames;
    private Collection<ResponsibleParty> contacts;
    private String dataSetUri;
    private long dateStamp;
    private String metadataStandardName;
    private String metadataStandardVersion;
    private Collection<SpatialRepresentation> spatialRepresentationInfo;
    private Collection<ReferenceSystem> referenceSystemInfo;
    private Collection<MetadataExtensionInformation> metadataExtensionInfo;
    private Collection<Identification> identificationInfo;
    private Collection<ContentInformation> contentInfo;
    private Distribution distributionInfo;
    private Collection<DataQuality> dataQualityInfo;
    private Collection<PortrayalCatalogueReference> portrayalCatalogueInfo;
    private Collection<Constraints> metadataConstraints;
    private Collection<ApplicationSchemaInformation> applicationSchemaInfo;
    private MaintenanceInformation metadataMaintenance;
    private Collection<AcquisitionInformation> acquisitionInformation;

    public DefaultMetadata() {
        this.dateStamp = Long.MIN_VALUE;
    }

    public DefaultMetadata(Metadata metadata) {
        super(metadata);
        if (metadata != null && this.dateStamp == 0L && metadata.getDateStamp() == null) {
            this.dateStamp = Long.MIN_VALUE;
        }
    }

    public DefaultMetadata(ResponsibleParty responsibleParty, Date date, Identification identification) {
        this();
        this.setContacts(Collections.singleton(responsibleParty));
        this.setDateStamp(date);
        this.setIdentificationInfo(Collections.singleton(identification));
    }

    public static DefaultMetadata castOrCopy(Metadata metadata) {
        return metadata == null || metadata instanceof DefaultMetadata ? (DefaultMetadata)metadata : new DefaultMetadata(metadata);
    }

    @XmlElement(name="fileIdentifier")
    public synchronized String getFileIdentifier() {
        return this.fileIdentifier;
    }

    public synchronized void setFileIdentifier(String string) {
        this.checkWritePermission();
        this.fileIdentifier = string;
    }

    @XmlElement(name="language")
    public synchronized Locale getLanguage() {
        return this.language;
    }

    public synchronized void setLanguage(Locale locale) {
        this.checkWritePermission();
        this.language = locale;
    }

    @XmlElement(name="characterSet")
    public synchronized CharacterSet getCharacterSet() {
        return this.characterSet;
    }

    public synchronized void setCharacterSet(CharacterSet characterSet) {
        this.checkWritePermission();
        this.characterSet = characterSet;
    }

    @XmlElement(name="parentIdentifier")
    public synchronized String getParentIdentifier() {
        return this.parentIdentifier;
    }

    public synchronized void setParentIdentifier(String string) {
        this.checkWritePermission();
        this.parentIdentifier = string;
    }

    @XmlElement(name="hierarchyLevel")
    public synchronized Collection<ScopeCode> getHierarchyLevels() {
        this.hierarchyLevels = this.nonNullCollection(this.hierarchyLevels, ScopeCode.class);
        return this.hierarchyLevels;
    }

    public synchronized void setHierarchyLevels(Collection<? extends ScopeCode> collection) {
        this.hierarchyLevels = this.copyCollection(collection, this.hierarchyLevels, ScopeCode.class);
    }

    @XmlElement(name="hierarchyLevelName")
    public synchronized Collection<String> getHierarchyLevelNames() {
        this.hierarchyLevelNames = this.nonNullCollection(this.hierarchyLevelNames, String.class);
        return this.hierarchyLevelNames;
    }

    public synchronized void setHierarchyLevelNames(Collection<? extends String> collection) {
        this.hierarchyLevelNames = this.copyCollection(collection, this.hierarchyLevelNames, String.class);
    }

    @XmlElement(name="contact", required=true)
    public synchronized Collection<ResponsibleParty> getContacts() {
        this.contacts = this.nonNullCollection(this.contacts, ResponsibleParty.class);
        return this.contacts;
    }

    public synchronized void setContacts(Collection<? extends ResponsibleParty> collection) {
        this.checkWritePermission();
        this.contacts = this.copyCollection(collection, this.contacts, ResponsibleParty.class);
    }

    @XmlElement(name="dateStamp", required=true)
    public synchronized Date getDateStamp() {
        return this.dateStamp != Long.MIN_VALUE ? new Date(this.dateStamp) : (Date)null;
    }

    public synchronized void setDateStamp(Date date) {
        this.checkWritePermission();
        this.dateStamp = date != null ? date.getTime() : Long.MIN_VALUE;
    }

    @XmlElement(name="metadataStandardName")
    public synchronized String getMetadataStandardName() {
        return this.metadataStandardName;
    }

    public synchronized void setMetadataStandardName(String string) {
        this.checkWritePermission();
        this.metadataStandardName = string;
    }

    @XmlElement(name="metadataStandardVersion")
    public synchronized String getMetadataStandardVersion() {
        return this.metadataStandardVersion;
    }

    public synchronized void setMetadataStandardVersion(String string) {
        this.checkWritePermission();
        this.metadataStandardVersion = string;
    }

    @XmlElement(name="spatialRepresentationInfo")
    public synchronized Collection<SpatialRepresentation> getSpatialRepresentationInfo() {
        this.spatialRepresentationInfo = this.nonNullCollection(this.spatialRepresentationInfo, SpatialRepresentation.class);
        return this.spatialRepresentationInfo;
    }

    public synchronized void setSpatialRepresentationInfo(Collection<? extends SpatialRepresentation> collection) {
        this.spatialRepresentationInfo = this.copyCollection(collection, this.spatialRepresentationInfo, SpatialRepresentation.class);
    }

    @XmlElement(name="referenceSystemInfo")
    public synchronized Collection<ReferenceSystem> getReferenceSystemInfo() {
        this.referenceSystemInfo = this.nonNullCollection(this.referenceSystemInfo, ReferenceSystem.class);
        return this.referenceSystemInfo;
    }

    public synchronized void setReferenceSystemInfo(Collection<? extends ReferenceSystem> collection) {
        this.referenceSystemInfo = this.copyCollection(collection, this.referenceSystemInfo, ReferenceSystem.class);
    }

    @XmlElement(name="metadataExtensionInfo")
    public synchronized Collection<MetadataExtensionInformation> getMetadataExtensionInfo() {
        this.metadataExtensionInfo = this.nonNullCollection(this.metadataExtensionInfo, MetadataExtensionInformation.class);
        return this.metadataExtensionInfo;
    }

    public synchronized void setMetadataExtensionInfo(Collection<? extends MetadataExtensionInformation> collection) {
        this.metadataExtensionInfo = this.copyCollection(collection, this.metadataExtensionInfo, MetadataExtensionInformation.class);
    }

    @XmlElement(name="identificationInfo", required=true)
    public synchronized Collection<Identification> getIdentificationInfo() {
        this.identificationInfo = this.nonNullCollection(this.identificationInfo, Identification.class);
        return this.identificationInfo;
    }

    public synchronized void setIdentificationInfo(Collection<? extends Identification> collection) {
        this.identificationInfo = this.copyCollection(collection, this.identificationInfo, Identification.class);
    }

    @XmlElement(name="contentInfo")
    public synchronized Collection<ContentInformation> getContentInfo() {
        this.contentInfo = this.nonNullCollection(this.contentInfo, ContentInformation.class);
        return this.contentInfo;
    }

    public synchronized void setContentInfo(Collection<? extends ContentInformation> collection) {
        this.contentInfo = this.copyCollection(collection, this.contentInfo, ContentInformation.class);
    }

    @XmlElement(name="distributionInfo")
    public synchronized Distribution getDistributionInfo() {
        return this.distributionInfo;
    }

    public synchronized void setDistributionInfo(Distribution distribution) {
        this.checkWritePermission();
        this.distributionInfo = distribution;
    }

    @XmlElement(name="dataQualityInfo")
    public synchronized Collection<DataQuality> getDataQualityInfo() {
        this.dataQualityInfo = this.nonNullCollection(this.dataQualityInfo, DataQuality.class);
        return this.dataQualityInfo;
    }

    public synchronized void setDataQualityInfo(Collection<? extends DataQuality> collection) {
        this.dataQualityInfo = this.copyCollection(collection, this.dataQualityInfo, DataQuality.class);
    }

    @XmlElement(name="portrayalCatalogueInfo")
    public synchronized Collection<PortrayalCatalogueReference> getPortrayalCatalogueInfo() {
        this.portrayalCatalogueInfo = this.nonNullCollection(this.portrayalCatalogueInfo, PortrayalCatalogueReference.class);
        return this.portrayalCatalogueInfo;
    }

    public synchronized void setPortrayalCatalogueInfo(Collection<? extends PortrayalCatalogueReference> collection) {
        this.portrayalCatalogueInfo = this.copyCollection(collection, this.portrayalCatalogueInfo, PortrayalCatalogueReference.class);
    }

    @XmlElement(name="metadataConstraints")
    public synchronized Collection<Constraints> getMetadataConstraints() {
        this.metadataConstraints = this.nonNullCollection(this.metadataConstraints, Constraints.class);
        return this.metadataConstraints;
    }

    public synchronized void setMetadataConstraints(Collection<? extends Constraints> collection) {
        this.metadataConstraints = this.copyCollection(collection, this.metadataConstraints, Constraints.class);
    }

    @XmlElement(name="applicationSchemaInfo")
    public synchronized Collection<ApplicationSchemaInformation> getApplicationSchemaInfo() {
        this.applicationSchemaInfo = this.nonNullCollection(this.applicationSchemaInfo, ApplicationSchemaInformation.class);
        return this.applicationSchemaInfo;
    }

    public synchronized void setApplicationSchemaInfo(Collection<? extends ApplicationSchemaInformation> collection) {
        this.applicationSchemaInfo = this.copyCollection(collection, this.applicationSchemaInfo, ApplicationSchemaInformation.class);
    }

    @XmlElement(name="metadataMaintenance")
    public synchronized MaintenanceInformation getMetadataMaintenance() {
        return this.metadataMaintenance;
    }

    public synchronized void setMetadataMaintenance(MaintenanceInformation maintenanceInformation) {
        this.checkWritePermission();
        this.metadataMaintenance = maintenanceInformation;
    }

    @XmlElement(name="locale")
    @XmlJavaTypeAdapter(value=PT_Locale.class)
    public synchronized Collection<Locale> getLocales() {
        this.locales = this.nonNullCollection(this.locales, Locale.class);
        return this.locales;
    }

    public synchronized void setLocales(Collection<? extends Locale> collection) {
        this.locales = this.copyCollection(collection, this.locales, Locale.class);
    }

    @XmlElement(name="dataSetURI")
    public synchronized String getDataSetUri() {
        return this.dataSetUri;
    }

    public synchronized void setDataSetUri(String string) {
        this.checkWritePermission();
        this.dataSetUri = string;
    }

    @XmlElement(name="acquisitionInformation", namespace="http://www.isotc211.org/2005/gmi")
    public synchronized Collection<AcquisitionInformation> getAcquisitionInformation() {
        this.acquisitionInformation = this.nonNullCollection(this.acquisitionInformation, AcquisitionInformation.class);
        return this.acquisitionInformation;
    }

    public synchronized void setAcquisitionInformation(Collection<? extends AcquisitionInformation> collection) {
        this.acquisitionInformation = this.copyCollection(collection, this.acquisitionInformation, AcquisitionInformation.class);
    }

    private void beforeMarshal(Marshaller marshaller) {
        MarshalContext.pushLocale((Locale)this.language);
    }

    private void afterMarshal(Marshaller marshaller) {
        MarshalContext.pullLocale();
    }
}

