/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.acquisition;

import java.util.Collection;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.jaxb.NonMarshalledAuthority;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.acquisition.Instrument;
import org.opengis.metadata.acquisition.Platform;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.util.InternationalString;

@ThreadSafe
@XmlType(name="MI_Platform_Type", propOrder={"citation", "identifier", "description", "sponsors", "instruments"})
@XmlRootElement(name="MI_Platform")
public class DefaultPlatform
extends MetadataEntity
implements Platform {
    private static final long serialVersionUID = -6870357428019309408L;
    private Citation citation;
    private InternationalString description;
    private Collection<ResponsibleParty> sponsors;
    private Collection<Instrument> instruments;

    public DefaultPlatform() {
    }

    public DefaultPlatform(Platform platform) {
        super(platform);
    }

    public static DefaultPlatform castOrCopy(Platform platform) {
        return platform == null || platform instanceof DefaultPlatform ? (DefaultPlatform)platform : new DefaultPlatform(platform);
    }

    @XmlElement(name="citation")
    public synchronized Citation getCitation() {
        return this.citation;
    }

    public synchronized void setCitation(Citation citation) {
        this.checkWritePermission();
        this.citation = citation;
    }

    @Override
    @XmlElement(name="identifier", required=true)
    public Identifier getIdentifier() {
        return super.getIdentifier();
    }

    public synchronized void setIdentifier(Identifier identifier) {
        this.checkWritePermission();
        NonMarshalledAuthority.setMarshallable(super.getIdentifiers(), (Identifier)identifier);
    }

    @XmlElement(name="description", required=true)
    public synchronized InternationalString getDescription() {
        return this.description;
    }

    public synchronized void setDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.description = internationalString;
    }

    @XmlElement(name="sponsor")
    public synchronized Collection<ResponsibleParty> getSponsors() {
        this.sponsors = this.nonNullCollection(this.sponsors, ResponsibleParty.class);
        return this.sponsors;
    }

    public synchronized void setSponsors(Collection<? extends ResponsibleParty> collection) {
        this.sponsors = this.copyCollection(collection, this.sponsors, ResponsibleParty.class);
    }

    @XmlElement(name="instrument", required=true)
    public synchronized Collection<Instrument> getInstruments() {
        this.instruments = this.nonNullCollection(this.instruments, Instrument.class);
        return this.instruments;
    }

    public synchronized void setInstruments(Collection<? extends Instrument> collection) {
        this.instruments = this.copyCollection(collection, this.instruments, Instrument.class);
    }
}

