/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.acquisition;

import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.jaxb.NonMarshalledAuthority;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.acquisition.Plan;
import org.opengis.metadata.acquisition.Priority;
import org.opengis.metadata.acquisition.RequestedDate;
import org.opengis.metadata.acquisition.Requirement;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;

@ThreadSafe
@XmlType(name="MI_Requirement_Type", propOrder={"citation", "identifier", "requestors", "recipients", "priority", "requestedDate", "expiryDate", "satisfiedPlans"})
@XmlRootElement(name="MI_Requirement")
public class DefaultRequirement
extends MetadataEntity
implements Requirement {
    private static final long serialVersionUID = 7305276418007196948L;
    private Citation citation;
    private Collection<ResponsibleParty> requestors;
    private Collection<ResponsibleParty> recipients;
    private Priority priority;
    private RequestedDate requestedDate;
    private long expiryDate;
    private Collection<Plan> satisfiedPlans;

    public DefaultRequirement() {
        this.expiryDate = Long.MIN_VALUE;
    }

    public DefaultRequirement(Requirement requirement) {
        super(requirement);
        if (requirement != null && this.expiryDate == 0L && requirement.getExpiryDate() == null) {
            this.expiryDate = Long.MIN_VALUE;
        }
    }

    public static DefaultRequirement castOrCopy(Requirement requirement) {
        return requirement == null || requirement instanceof DefaultRequirement ? (DefaultRequirement)requirement : new DefaultRequirement(requirement);
    }

    @XmlElement(name="citation")
    public synchronized Citation getCitation() {
        return this.citation;
    }

    public synchronized void setCitation(Citation citation) {
        this.checkWritePermission();
        this.citation = citation;
    }

    @Override
    @XmlElement(name="identifier", required=true)
    public Identifier getIdentifier() {
        return super.getIdentifier();
    }

    public synchronized void setIdentifier(Identifier identifier) {
        this.checkWritePermission();
        NonMarshalledAuthority.setMarshallable(super.getIdentifiers(), (Identifier)identifier);
    }

    @XmlElement(name="requestor", required=true)
    public synchronized Collection<ResponsibleParty> getRequestors() {
        this.requestors = this.nonNullCollection(this.requestors, ResponsibleParty.class);
        return this.requestors;
    }

    public synchronized void setRequestors(Collection<? extends ResponsibleParty> collection) {
        this.requestors = this.copyCollection(collection, this.requestors, ResponsibleParty.class);
    }

    @XmlElement(name="recipient", required=true)
    public synchronized Collection<ResponsibleParty> getRecipients() {
        this.recipients = this.nonNullCollection(this.recipients, ResponsibleParty.class);
        return this.recipients;
    }

    public synchronized void setRecipients(Collection<? extends ResponsibleParty> collection) {
        this.recipients = this.copyCollection(collection, this.recipients, ResponsibleParty.class);
    }

    @XmlElement(name="priority", required=true)
    public synchronized Priority getPriority() {
        return this.priority;
    }

    public synchronized void setPriority(Priority priority) {
        this.checkWritePermission();
        this.priority = priority;
    }

    @XmlElement(name="requestedDate", required=true)
    public synchronized RequestedDate getRequestedDate() {
        return this.requestedDate;
    }

    public synchronized void setRequestedDate(RequestedDate requestedDate) {
        this.checkWritePermission();
        this.requestedDate = requestedDate;
    }

    @XmlElement(name="expiryDate", required=true)
    public synchronized Date getExpiryDate() {
        long l = this.expiryDate;
        return l != Long.MIN_VALUE ? new Date(l) : null;
    }

    public synchronized void setExpiryDate(Date date) {
        this.checkWritePermission();
        this.expiryDate = date != null ? date.getTime() : Long.MIN_VALUE;
    }

    @XmlElement(name="satisfiedPlan")
    public synchronized Collection<Plan> getSatisfiedPlans() {
        this.satisfiedPlans = this.nonNullCollection(this.satisfiedPlans, Plan.class);
        return this.satisfiedPlans;
    }

    public synchronized void setSatisfiedPlans(Collection<? extends Plan> collection) {
        this.satisfiedPlans = this.copyCollection(collection, this.satisfiedPlans, Plan.class);
    }
}

